/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import org.apache.velocity.VelocityContext;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;

/**
 * Creates a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic} on a
 * {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class CreateJbossasTopicStep extends JbossasStepBase {

	private JbossasTopic topic;

	public CreateJbossasTopicStep(JbossasServer server, JbossasTopic topic) {
		super(server);
		this.topic = topic;
		setDescription("Create topic " + topic + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		String evaluatedTemplate = generateServiceFile();

		HostSession s = server.connectToAdminHost();
		try {
			HostFile tmpDir = s.getFile(server.getTmpDirPath());
			HostFile tmpTopicServiceFile = s.getFile(tmpDir, topic.getFilename());
			ctx.logOutput("Copying topic configuration to " + tmpTopicServiceFile.getPath() + " on " + server.getHost());
			HostFileUtils.putStringToHostFile(evaluatedTemplate, tmpTopicServiceFile);

			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile topicServiceFile = s.getFile(deployDir, topic.getFilename());
			ctx.logOutput("Moving topic configuration from " + tmpTopicServiceFile.getPath() + " to " + topicServiceFile.getPath() + " on " + server.getHost());
			tmpTopicServiceFile.moveTo(topicServiceFile);

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

	private String generateServiceFile() {
		String templateResourceName = server.getVersion() == JbossasVersion.JBOSSAS_40 ? "template-topic-service-jboss4.xml.vm"
				: "template-topic-service-jboss5.xml.vm";

		VelocityContext context = new VelocityContext();
		context.put("topic", topic);
		return VelocityUtils.evaluateTemplate(context, STEP_RESOURCES_PATH + templateResourceName);
	}

}
