package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

@SuppressWarnings("serial")
public class JbossasWaitForDeploymentsToCompleteStep implements Step {

	public String getDescription() {
		return "Wait " + JbossasServer.DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS + "ms for JBoss server to complete deployments";
	}

	public boolean execute(StepExecutionContext ctx) {
		ctx.logOutput("Waiting " + JbossasServer.DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS + "ms for JBoss server to complete deployments");
		try {
			Thread.sleep(JbossasServer.DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS);
		} catch (InterruptedException ignored) {
		}
		return true;
	}

}
