/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;

@ConfigurationItem(description="JBoss Application Server instance", targetForMappingTypes={EarMapping.class})
public class JbossasServer
extends BaseConfigurationItem {
    public static final int DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS = 10000;
    @ConfigurationItemProperty(required=true, label="JBoss version", description="Version of the JBoss serve.r")
    private JbossasVersion version;
    @ConfigurationItemProperty(required=true, label="JBoss server host", description="Host on which the JBoss server is running.")
    private Host host;
    @ConfigurationItemProperty(required=true, label="JBoss installation location", description="Place where JBoss is installed such as /usr/local/jboss-5.1.0.GA.", size=ConfigurationItemProperty.Size.LARGE)
    private String home;
    @ConfigurationItemProperty(required=true, label="JBoss instance name", description="Name of the JBoss server instance, e.g. default or minimal.")
    private String name;
    @ConfigurationItemProperty(required=false, label="JBoss restart command", description="Command that should be executed to restart the JBoss server.", size=ConfigurationItemProperty.Size.LARGE)
    private String restartCommand;

    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "server" + fileSep + this.getName() + fileSep + "deploy";
    }

    public String getTmpDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "server" + fileSep + this.getName() + fileSep + "tmp";
    }

    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public JbossasVersion getVersion() {
        return this.version;
    }

    public void setVersion(JbossasVersion version) {
        this.version = version;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRestartCommand() {
        return this.restartCommand;
    }

    public void setRestartCommand(String restartCommand) {
        this.restartCommand = restartCommand;
    }
}

