/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.artifact.ConfigurationFilesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.LibrariesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.SqlScriptToDatabaseMapper;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.mapper.EarToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.JbossasDataSourceToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.JbossasQueueToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.JbossasTopicToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.mapper.WarToJbossasServerMapper;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasRestartServerStep;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasWaitForDeploymentsToCompleteStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbossasDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment> {
    public JbossasDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        WarToJbossasServerMapper warToServerMapper = new WarToJbossasServerMapper(change);
        EarToJbossasServerMapper earToServerMapper = new EarToJbossasServerMapper(change);
        JbossasDataSourceToJbossasServerMapper dataSourceToServerMapper = new JbossasDataSourceToJbossasServerMapper(change);
        JbossasQueueToJbossasServerMapper queueToServerMapper = new JbossasQueueToJbossasServerMapper(change);
        JbossasTopicToJbossasServerMapper topicToServerMapper = new JbossasTopicToJbossasServerMapper(change);
        LibrariesToHostMapper librariesMapper = new LibrariesToHostMapper(change);
        ConfigurationFilesToHostMapper configurationFilesToHostMapper = new ConfigurationFilesToHostMapper(change);
        HashSet<JbossasServer> affectedServers = new HashSet<JbossasServer>();
        affectedServers.addAll(warToServerMapper.getAffectedTargets());
        affectedServers.addAll(earToServerMapper.getAffectedTargets());
        affectedServers.addAll(dataSourceToServerMapper.getAffectedTargets());
        affectedServers.addAll(queueToServerMapper.getAffectedTargets());
        affectedServers.addAll(topicToServerMapper.getAffectedTargets());
        if (!this.isJbossasDeployment(warToServerMapper, earToServerMapper, dataSourceToServerMapper, queueToServerMapper, topicToServerMapper)) {
            return;
        }
        int lastStepCount = steps.size();
        earToServerMapper.generateDeletionSteps(steps);
        warToServerMapper.generateDeletionSteps(steps);
        topicToServerMapper.generateDeletionSteps(steps);
        queueToServerMapper.generateDeletionSteps(steps);
        dataSourceToServerMapper.generateDeletionSteps(steps);
        configurationFilesToHostMapper.generateDeletionSteps(steps);
        librariesMapper.generateDeletionSteps(steps);
        SqlScriptToDatabaseMapper sqlMapper = new SqlScriptToDatabaseMapper(change);
        sqlMapper.generateAdditionSteps(steps);
        librariesMapper.generateAdditionSteps(steps);
        configurationFilesToHostMapper.generateAdditionSteps(steps);
        dataSourceToServerMapper.generateAdditionSteps(steps);
        queueToServerMapper.generateAdditionSteps(steps);
        topicToServerMapper.generateAdditionSteps(steps);
        warToServerMapper.generateAdditionSteps(steps);
        earToServerMapper.generateAdditionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.restartServers(affectedServers, steps);
        }
    }

    private boolean isJbossasDeployment(WarToJbossasServerMapper warToServerMapper, EarToJbossasServerMapper earToServerMapper, JbossasDataSourceToJbossasServerMapper dataSourceToServerMapper, JbossasQueueToJbossasServerMapper queueToServerMapper, JbossasTopicToJbossasServerMapper topicToServerMapper) {
        HashSet allServers = new HashSet();
        allServers.addAll(warToServerMapper.getAllTargets());
        allServers.addAll(earToServerMapper.getAllTargets());
        allServers.addAll(dataSourceToServerMapper.getAllTargets());
        allServers.addAll(queueToServerMapper.getAllTargets());
        allServers.addAll(topicToServerMapper.getAllTargets());
        return !allServers.isEmpty();
    }

    private void restartServers(Set<JbossasServer> servers, List<Step> steps) {
        for (JbossasServer eachServer : servers) {
            if (eachServer.getRestartCommand() == null) continue;
            steps.add(new JbossasRestartServerStep(eachServer));
        }
        steps.add(new JbossasWaitForDeploymentsToCompleteStep());
    }
}

