package com.xebialabs.deployit.plugin.jbossas.runbook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;

/**
 * A base runbook that is designed to be extended by runbooks that are only
 * interested in changes to CIs of a given type.
 */
public abstract class JbossasSingleTypeRunBook<T extends Serializable> implements RunBook {

	private final Class<? extends Serializable> ciType;

	protected JbossasSingleTypeRunBook(Class<? extends Serializable> ciType) {
		this.ciType = ciType;
	}

	@SuppressWarnings("unchecked")
	public Collection<ChangeResolution> resolve(ChangePlan changePlan) {
		Collection<ChangeResolution> crs = new ArrayList<ChangeResolution>();
		for (Change<?> eachChange : changePlan.getChanges()) {
			if (eachChange.getConfigurationItemClass() == ciType) {
				List<Step> steps = new ArrayList<Step>();
				resolve((Change<T>) eachChange, steps);
				if (!steps.isEmpty()) {
					ChangeResolution cr = new ChangeResolution(eachChange);
					cr.addSteps(steps);
					crs.add(cr);
				}
			}
		}
		return crs;
	}

	protected abstract void resolve(Change<T> change, List<Step> steps);

}
