package com.xebialabs.deployit.plugin.jbossas.step;

import org.apache.velocity.VelocityContext;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;

/**
 * Creates a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue} on a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class CreateJbossasQueueStep extends JbossasStepBase {

	private JbossasQueue queue;

	public CreateJbossasQueueStep(JbossasServer server, JbossasQueue queue) {
		super(server);
		this.queue = queue;
		setDescription("Create queue " + queue + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		VelocityContext context = new VelocityContext();
		context.put("queue", queue);
		String evaluatedTemplate = VelocityUtils.evaluateTemplate(context, STEP_RESOURCES_PATH + "template-queue-service.xml.vm");

		HostSession s = server.connectToAdminHost();
		try {
			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile queueServiceFile = s.getFile(deployDir, queue.getFilename());

			ctx.logOutput("Copying queue configuration to " + queueServiceFile.getPath() + " on " + server.getHost());
			HostFileUtils.putStringToHostFile(evaluatedTemplate, queueServiceFile);

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

}
