package com.xebialabs.deployit.plugin.jbossas.step;

import org.apache.velocity.VelocityContext;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;

/**
 * Creates a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic} on a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class CreateJbossasTopicStep extends JbossasStepBase {

	private JbossasTopic topic;

	public CreateJbossasTopicStep(JbossasServer server, JbossasTopic topic) {
		super(server);
		this.topic = topic;
		setDescription("Create topic " + topic + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		VelocityContext context = new VelocityContext();
		context.put("topic", topic);
		String evaluatedTemplate = VelocityUtils.evaluateTemplate(context, STEP_RESOURCES_PATH + "template-topic-service.xml.vm");

		HostSession s = server.connectToAdminHost();
		try {
			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile topicServiceFile = s.getFile(deployDir, topic.getFilename());

			ctx.logOutput("Copying topic configuration to " + topicServiceFile.getPath() + " on " + server.getHost());
			HostFileUtils.putStringToHostFile(evaluatedTemplate, topicServiceFile);

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

}
