package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

/**
 * Destroys a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource} on a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class DestroyJbossasDataSourceStep extends JbossasStepBase {

	private JbossasDataSource dataSource;

	public DestroyJbossasDataSourceStep(JbossasServer server, JbossasDataSource dataSource) {
		super(server);
		this.dataSource = dataSource;
		setDescription("Destroy datasource " + dataSource + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {

		HostSession s = server.connectToAdminHost();
		try {
			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile dsFile = s.getFile(deployDir, dataSource.getFilename());

			ctx.logOutput("Removing datasource configuration from " + dsFile.getPath() + " on " + server.getHost());
			dsFile.delete();

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

}
