package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

/**
 * Restarts a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer} It blocks until the server has been restarted. It times out after
 * {@link JbossasRestartServerStep#RESTART_DONE_MAX_CHECKS} ms * {@link JbossasRestartServerStep#RESTART_DONE_CHECK_INTERVAL_MILLIS} ms
 */
@SuppressWarnings("serial")
public class JbossasRestartServerStep extends JbossasStepBase {

	public static final int RESTART_DONE_CHECK_INTERVAL_MILLIS = 1000;

	public static final int RESTART_DONE_MAX_CHECKS = 20;

	public static final int SETTLE_MILLIS = 5000;

	public JbossasRestartServerStep(JbossasServer server) {
		super(server);
		setDescription("Restart JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			s.execute(new StepExecutionContextCallbackHandler(ctx), server.getShutdownFilePath(), "-s", server.getHost().getAddress(), "-e", "10");
			for (int i = 0; i < RESTART_DONE_MAX_CHECKS; i++) {
				CapturingCommandExecutionCallbackHandler h = new CapturingCommandExecutionCallbackHandler();
				int twiddleResult = s
						.execute(h, server.getTwiddleFilePath(), "-s", server.getHost().getAddress(), "get", "jboss.system:type=Server", "Started");
				if (twiddleResult == 0) {
					ctx.logOutput("Server has restarted. Waiting " + SETTLE_MILLIS + " milliseconds for it to settle.");
					try {
						Thread.sleep(SETTLE_MILLIS);
					} catch (InterruptedException ignore) {
					}
					return true;
				}
				try {
					ctx.logOutput("Server hasn't restarted yet. Waiting " + RESTART_DONE_CHECK_INTERVAL_MILLIS + " milliseconds before checking again...");
					Thread.sleep(RESTART_DONE_CHECK_INTERVAL_MILLIS);
				} catch (InterruptedException ignore) {
				}
			}
			ctx.logOutput("Giving up waiting for server to restart after " + RESTART_DONE_MAX_CHECKS + " checks.");
			return false;
		} finally {
			s.close();
		}
	}

}
