package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

/**
 * Undeploys a {@link com.xebialabs.deployit.ci.artifact.Ear} or a {@link com.xebialabs.deployit.ci.artifact.War} from a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class JbossasUndeployApplicationStep extends JbossasDeploymentStepBase {

	public JbossasUndeployApplicationStep(JbossasServer server, Ear ear) {
		super(server, ear);
		setDescription("Undeploy EAR file " + ear + " from JBoss server " + server);
	}

	public JbossasUndeployApplicationStep(JbossasServer server, War war) {
		super(server, war);
		setDescription("Undeploy WAR file " + war + " from JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile targetFile = getArtifactTargetFile(s);

			ctx.logOutput("Removing application artifact from " + targetFile.getPath() + " on " + server.getHost());
			targetFile.delete();

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

}
