/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;

public class JbossasRestartServerStep
extends JbossasStepBase {
    public static final int RESTART_DONE_CHECK_INTERVAL_MILLIS = 1000;
    public static final int RESTART_DONE_MAX_CHECKS = 20;
    public static final int SETTLE_MILLIS = 5000;

    public JbossasRestartServerStep(JbossasServer server) {
        super(server);
        this.setDescription("Restart JBoss server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            s.execute((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), new String[]{this.server.getShutdownFilePath(), "-s", this.server.getHost().getAddress(), "-e", "10"});
            for (int i = 0; i < 20; ++i) {
                CapturingCommandExecutionCallbackHandler h = new CapturingCommandExecutionCallbackHandler();
                int twiddleResult = s.execute((CommandExecutionCallbackHandler)h, new String[]{this.server.getTwiddleFilePath(), "-s", this.server.getHost().getAddress(), "get", "jboss.system:type=Server", "Started"});
                if (twiddleResult == 0) {
                    ctx.logOutput("Server has restarted. Waiting 5000 milliseconds for it to settle.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    boolean ignore = true;
                    return ignore;
                }
                try {
                    ctx.logOutput("Server hasn't restarted yet. Waiting 1000 milliseconds before checking again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            ctx.logOutput("Giving up waiting for server to restart after 20 checks.");
            boolean bl = false;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

