/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import org.apache.velocity.VelocityContext;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;

/**
 * Creates a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue} on a
 * {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class CreateJbossasQueueStep extends JbossasStepBase {

	private JbossasQueue queue;

	public CreateJbossasQueueStep(JbossasServer server, JbossasQueue queue) {
		super(server);
		this.queue = queue;
		setDescription("Create queue " + queue + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		String evaluatedTemplate = generateQueueConfigurationFile();

		HostSession s = server.connectToAdminHost();
		try {
			HostFile tmpDir = s.getFile(server.getTmpDirPath());
			HostFile tmpQueueServiceFile = s.getFile(tmpDir, queue.getFilename());
			ctx.logOutput("Copying queue configuration to " + tmpQueueServiceFile.getPath() + " on " + server.getHost());
			HostFileUtils.putStringToHostFile(evaluatedTemplate, tmpQueueServiceFile);

			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile queueServiceFile = s.getFile(deployDir, queue.getFilename());
			ctx.logOutput("Moving queue configuration from " + tmpQueueServiceFile.getPath() + " to " + queueServiceFile.getPath() + " on " + server.getHost());
			tmpQueueServiceFile.moveTo(queueServiceFile);

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

	private String generateQueueConfigurationFile() {
		String templateResourceName = server.getVersion() == JbossasVersion.JBOSSAS_40 ? "template-queue-service-jboss4.xml.vm"
				: "template-queue-service-jboss5.xml.vm";

		VelocityContext context = new VelocityContext();
		context.put("queue", queue);
		return VelocityUtils.evaluateTemplate(context, STEP_RESOURCES_PATH + templateResourceName);
	}

}
