/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;
import org.apache.velocity.VelocityContext;

public class CreateJbossasDataSourceStep
extends JbossasStepBase {
    private JbossasDataSource dataSource;

    public CreateJbossasDataSourceStep(JbossasServer server, JbossasDataSource dataSource) {
        super(server);
        this.dataSource = dataSource;
        this.setDescription("Create datasource " + (Object)((Object)dataSource) + " on JBoss server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        String evaluatedTemplate = this.generateDataSourceConfigurationFile();
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile tmpDir = s.getFile(this.server.getTmpDirPath());
            HostFile tmpDsFile = s.getFile(tmpDir, this.dataSource.getFilename());
            ctx.logOutput("Copying datasource configuration to " + tmpDsFile.getPath() + " on " + this.server.getHost());
            HostFileUtils.putStringToHostFile((String)evaluatedTemplate, (HostFile)tmpDsFile);
            HostFile deployDir = s.getFile(this.server.getDeployDirPath());
            HostFile dsFile = s.getFile(deployDir, this.dataSource.getFilename());
            ctx.logOutput("Moving datasource configuration from " + tmpDsFile.getPath() + " to " + dsFile.getPath() + " on " + this.server.getHost());
            tmpDsFile.moveTo(dsFile);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }

    private String generateDataSourceConfigurationFile() {
        VelocityContext context = new VelocityContext();
        context.put("datasource", (Object)this.dataSource);
        return VelocityUtils.evaluateTemplate(context, "com/xebialabs/deployit/plugin/jbossas/step/template-ds.xml.vm");
    }
}

