/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.support.XPathUtils;
import org.apache.commons.lang.StringUtils;

@SuppressWarnings("serial")
public class CheckControlPortStep extends JbossasStepBase {
	static final String XPATH_JBOSS4 = "/server/mbean[@code='org.jboss.naming.NamingService']/attribute[@name='Port']";
	static final String XPATH_JBOSS5 = "//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss:service=Naming' and property='Port']/property[@name='port']";
	static final String XPATH_JBOSS6 = "//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.remoting:service=JMXConnectorServer,protocol=rmi']/property[@name='port']";

	public CheckControlPortStep(JbossasServer server) {
		super(server);
		setDescription("Check the naming directory port of the jboss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		switch (server.getVersion()) {
			case JBOSSAS_40:
				return checkNamingPortJBoss4(ctx);
			case JBOSSAS_50:
				return checkNamingPortJBoss5(ctx);
			case JBOSSAS_60:
				return checkNamingPortJBoss6(ctx);
			default:
				ctx.logOutput("Implementation of the step not done for this version" + server.getVersion());
				return true;
		}
	}

	private boolean checkNamingPortJBoss6(StepExecutionContext ctx) {
		//itest/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml
		//For JBoss6 we fetch the port of jboss.remoting:service=JMXConnectorServer,protocol=rmi
		HostSession s = server.connectToAdminHost();
		try {
			String fileSep = server.getHost().getFileSeparator();
			final String configurationFilePath = (server.getInstanceDirPath() + "/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml").replace("/", fileSep);
			HostFile configuration = s.getFile(configurationFilePath);
			ctx.logOutput("Configuration file is " + configuration);
			String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS6);
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS6 + " gives no candidates");
			} else {
				server.setControlPort(Integer.parseInt(nodes.trim()));
			}
			return true;
		}
		catch (Exception e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} finally {
			s.close();
		}
	}

	private boolean checkNamingPortJBoss5(StepExecutionContext ctx) {
		//itest/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml
		HostSession s = server.connectToAdminHost();
		try {
			String fileSep = server.getHost().getFileSeparator();
			final String configurationFilePath = (server.getInstanceDirPath() + "/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml").replace("/", fileSep);
			HostFile configuration = s.getFile(configurationFilePath);
			ctx.logOutput("Configuration file is " + configuration);
			String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS5);
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS5 + " gives no candidates");
			} else {
				server.setControlPort(Integer.parseInt(nodes.trim()));
			}
			return true;
		}
		catch (Exception e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} finally {
			s.close();
		}
	}

	private boolean checkNamingPortJBoss4(StepExecutionContext ctx) {
		//check in /opt/jboss/4.2.3-GA/server/${server.name}/conf/jboss-service.xml
		HostSession s = server.connectToAdminHost();
		try {
			String fileSep = server.getHost().getFileSeparator();
			HostFile configuration = s.getFile(server.getInstanceDirPath() + fileSep + "conf" + fileSep + "jboss-service.xml");
			ctx.logOutput("Configuration file is " + configuration);
			String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS4);
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS4 + " gives no candidates");
			} else {
				server.setControlPort(Integer.parseInt(nodes.trim()));
			}
			return true;
		}
		catch (Exception e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} finally {
			s.close();
		}
	}



}
