/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;
import org.apache.velocity.VelocityContext;

/**
 * Creates a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource} on a
 * {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class CreateJbossasDataSourceStep extends JbossasStepBase {

	private JbossasDataSource dataSource;

	public CreateJbossasDataSourceStep(JbossasServer server, JbossasDataSource dataSource) {
		super(server);
		this.dataSource = dataSource;
		setDescription("Create datasource " + dataSource + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		String evaluatedTemplate = generateDataSourceConfigurationFile();

		HostSession s = server.connectToAdminHost();
		try {
			HostFile tmpDir = s.getFile(server.getTmpDirPath());
			HostFile tmpDsFile = s.getFile(tmpDir, dataSource.getFilename());
			ctx.logOutput("Copying datasource configuration to " + tmpDsFile.getPath() + " on " + server.getHost());
			HostFileUtils.putStringToHostFile(evaluatedTemplate, tmpDsFile);

			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile dsFile = s.getFile(deployDir, dataSource.getFilename());
			ctx.logOutput("Moving datasource configuration from " + tmpDsFile.getPath() + " to " + dsFile.getPath() + " on " + server.getHost());
			tmpDsFile.moveTo(dsFile);

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

	private String generateDataSourceConfigurationFile() {
		VelocityContext context = new VelocityContext();
		context.put("datasource", dataSource);
		return VelocityUtils.evaluateTemplate(context, STEP_RESOURCES_PATH + "template-ds.xml.vm");
	}

}
