/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasArtifactServerMapping;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasWarMapping;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class JbossasDeploymentStepBase
extends JbossasStepBase {
    protected NamedDeployableArtifact artifact;
    private JbossasArtifactServerMapping mapping;

    protected JbossasDeploymentStepBase(JbossasServer server, NamedDeployableArtifact artifact, JbossasArtifactServerMapping mapping) {
        super(server);
        this.artifact = artifact;
        this.mapping = mapping;
    }

    protected String getArtifactTargetFileName() {
        String targetFileName = this.artifact.getName();
        if (this.artifact instanceof Ear) {
            targetFileName = targetFileName + ".ear";
        } else if (this.artifact instanceof War) {
            JbossasWarMapping warMapping;
            targetFileName = targetFileName + ".war";
            if (this.mapping != null && this.mapping instanceof JbossasWarMapping && StringUtils.isNotBlank((String)(warMapping = (JbossasWarMapping)this.mapping).getContextRoot())) {
                targetFileName = warMapping.getContextRoot() + ".war";
            }
        } else if (this.artifact instanceof EjbJar) {
            targetFileName = targetFileName + ".jar";
        } else {
            throw new IllegalArgumentException("Artifact " + this.artifact + " is neither an EAR, a WAR nor an EJB JAR");
        }
        return targetFileName;
    }

    protected HostFileInputStreamTransformer getTransformer() {
        if (this.mapping == null) {
            return null;
        }
        Map<String, String> keyValueMap = this.mapping.getKeyValueMap();
        if (keyValueMap.isEmpty()) {
            return null;
        }
        return new LenientTemplateResolvingArchiveHostFileInputTransformer(keyValueMap, this.mapping.getPlaceholderFormat());
    }
}

