/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasEarMapping;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasEjbJarMapping;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasWarMapping;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasDeploymentStepBase;

public class JbossasUndeployApplicationStep
extends JbossasDeploymentStepBase {
    public JbossasUndeployApplicationStep(JbossasServer server, Ear ear, JbossasEarMapping mapping) {
        super(server, (NamedDeployableArtifact)ear, mapping);
        this.setDescription("Undeploy EAR " + ear + " from JBoss server " + (Object)((Object)server));
    }

    public JbossasUndeployApplicationStep(JbossasServer server, War war, JbossasWarMapping mapping) {
        super(server, (NamedDeployableArtifact)war, mapping);
        this.setDescription("Undeploy WAR " + war + " from JBoss server " + (Object)((Object)server));
    }

    public JbossasUndeployApplicationStep(JbossasServer server, EjbJar ejbJar, JbossasEjbJarMapping mapping) {
        super(server, (NamedDeployableArtifact)ejbJar, mapping);
        this.setDescription("Undeploy EJB " + ejbJar + " from JBoss server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            String artifactTargetFileName = this.getArtifactTargetFileName();
            HostFile deployDir = s.getFile(this.server.getDeployDirPath());
            HostFile targetDeployFile = deployDir.getFile(artifactTargetFileName);
            ctx.logOutput("Removing application artifact from " + targetDeployFile.getPath() + " on " + this.server.getHost());
            targetDeployFile.delete();
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

