package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.IOException;
import java.io.InputStream;

@SuppressWarnings("serial")
public class CheckJbossasDeployDirPath extends JbossasStepBase {
	static final String XPATH_JBOSS4 = "/server/mbean[@code='org.jboss.deployment.scanner.URLDeploymentScanner']/attribute[@name='URLs']";

	public CheckJbossasDeployDirPath(JbossasServer server) {
		super(server);
		setDescription("Check the deploy directory path of the jboss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		switch (server.getVersion()) {
			case JBOSSAS_40:
				return checkDirPathJBoss4(ctx);
			default:
				ctx.logOutput("Implementation of the step not done for this version" + server.getVersion());
				return true;
		}
	}

	private boolean checkDirPathJBoss4(StepExecutionContext ctx) {
		//check in /opt/jboss/4.2.3-GA/server/${server.name}/conf/jboss-service.xml
		//http://community.jboss.org/wiki/ConfiguringTheDeploymentScannerInConfjbossSystemxml
		//XPATH_JBOSS4 /server/mbean[@code='org.jboss.deployment.scanner.URLDeploymentScanner']/attribute[@name='URLs']

		HostSession s = server.connectToAdminHost();
		InputStream inputStream = null;
		try {
			String fileSep = server.getHost().getFileSeparator();
			HostFile configuration = s.getFile(server.getInstanceDirPath() + fileSep + "conf" + fileSep + "jboss-service.xml");
			ctx.logOutput("Configuration file is " + configuration);
			inputStream = configuration.get();
			final Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
			final XPathExpression expression = XPathFactory.newInstance().newXPath().compile(XPATH_JBOSS4);

			final Object o = expression.evaluate(document, XPathConstants.STRING);
			String nodes = (String) o;
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS4 + " gives no candidates");
			} else {
				for (String path : StringUtils.split(nodes.trim(), ","))
					server.addDeployDir(path);
			}
			return true;
		}
		catch (XPathExpressionException e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} catch (ParserConfigurationException e) {
			ctx.logError("XML/Source Exception", e);
			return false;
		} catch (SAXException e) {
			ctx.logError("XML/Source Parse Exception", e);
			return false;
		} catch (IOException e) {
			ctx.logError("XML/Source IO Exception", e);
			return false;
		} finally {
			IOUtils.closeQuietly(inputStream);
			s.close();
		}
	}
}
