/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.v1;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseProperty;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class License {
    public static final String VERSION = "1";
    public static final String LICENSE_V1_PREAMBLE = "--- License V1 ---";
    public static final String PRODUCT_DEPLOYIT = "XL Deploy";
    public static final String PRODUCT_OLD_DEPLOYIT = "Deployit";
    public static final String PRODUCT_XL_RELEASE = "XL Release";
    public static final Set<String> PRODUCTS = Sets.newHashSet((Object[])new String[]{"XL Deploy", "XL Release", "Deployit"});
    public static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    protected LocalDate expiresAfter;
    protected String licensedTo;
    protected String contact;
    protected String repositoryId;
    protected String maxNumberOfUsers;
    protected String product;

    public void validate() {
        Preconditions.checkNotNull((Object)this.getExpiresAfter(), (Object)"expiresAfter cannot be null");
        Preconditions.checkNotNull((Object)this.licensedTo, (Object)"licensedTo cannot be null");
        Preconditions.checkArgument((!this.licensedTo.trim().isEmpty() ? 1 : 0) != 0, (Object)"licensedTo cannot be empty");
        Preconditions.checkNotNull((Object)this.contact, (Object)"contact cannot be null");
        Preconditions.checkArgument((!this.contact.trim().isEmpty() ? 1 : 0) != 0, (Object)"contact cannot be empty");
        Preconditions.checkArgument((boolean)PRODUCTS.contains(this.getProduct()), (Object)String.format("product should be one of: %s got '%s'", PRODUCTS, this.getProduct()));
    }

    public String getLicenseVersion() {
        return VERSION;
    }

    public LocalDate getExpiresAfter() {
        return this.expiresAfter;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public String getContact() {
        return this.contact;
    }

    public String getProduct() {
        return this.product;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getMaxNumberOfUsers() {
        return this.maxNumberOfUsers;
    }

    public boolean setProperty(LicenseProperty licenseProperty, String value) {
        if (licenseProperty.isRequired()) {
            Preconditions.checkNotNull((Object)value, (Object)String.format("Cannot set %s to null", licenseProperty.getName()));
        }
        value = value != null ? value.trim() : null;
        switch (licenseProperty) {
            case LICENSED_TO: {
                this.licensedTo = value;
                break;
            }
            case CONTACT: {
                this.contact = value;
                break;
            }
            case EXPIRES_AFTER: {
                this.expiresAfter = License.parseDate(value);
                break;
            }
            case PRODUCT: {
                this.product = value;
                break;
            }
            case REPOSITORY_ID: {
                this.repositoryId = value;
                break;
            }
            case MAX_NUMBER_OF_USERS: {
                this.maxNumberOfUsers = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Object getProperty(LicenseProperty licenseProperty) {
        switch (licenseProperty) {
            case LICENSED_TO: {
                return this.getLicensedTo();
            }
            case CONTACT: {
                return this.getContact();
            }
            case EXPIRES_AFTER: {
                return this.getExpiresAfter();
            }
            case PRODUCT: {
                return this.getProduct();
            }
            case REPOSITORY_ID: {
                return this.getRepositoryId();
            }
            case MAX_NUMBER_OF_USERS: {
                return this.getMaxNumberOfUsers();
            }
        }
        throw new IllegalArgumentException(String.format("unknown property '%s'", licenseProperty.getName()));
    }

    private String format(LicenseProperty licenseProperty, String format) {
        switch (licenseProperty) {
            case EXPIRES_AFTER: {
                return String.format(format, LicenseProperty.EXPIRES_AFTER.getName(), LICENSE_DATE_FORMAT.print((ReadablePartial)this.getExpiresAfter()));
            }
        }
        String value = (String)this.getProperty(licenseProperty);
        return value != null ? String.format(format, licenseProperty.getName(), value) : "";
    }

    private String formatAll(String format) {
        StringBuilder licenseContent = new StringBuilder();
        licenseContent.append(this.format(LicenseProperty.PRODUCT, format));
        licenseContent.append(this.format(LicenseProperty.LICENSED_TO, format));
        licenseContent.append(this.format(LicenseProperty.CONTACT, format));
        licenseContent.append(this.format(LicenseProperty.REPOSITORY_ID, format));
        licenseContent.append(this.format(LicenseProperty.EXPIRES_AFTER, format));
        licenseContent.append(this.format(LicenseProperty.MAX_NUMBER_OF_USERS, format));
        return licenseContent.toString();
    }

    private static LocalDate parseDate(String date) {
        try {
            return LocalDate.parse((String)date, (DateTimeFormatter)LICENSE_DATE_FORMAT);
        }
        catch (Exception e) {
            throw new InvalidLicenseException(String.format("Unable to parse date '%s'", date));
        }
    }

    public String toLicenseContent() {
        return this.formatAll("%s: %s%n");
    }

    public String toString() {
        return this.formatAll("%-" + String.valueOf(LicenseProperty.getLongerNameLength()) + "s: %s%n");
    }
}

