package com.xebialabs.license;

import java.util.List;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;

import static com.xebialabs.license.LicenseProperty.*;

public class LicenseVersion2 extends License {
    public static final String VERSION = "2";

    public LicenseVersion2(Multimap<LicenseProperty, String> values) {
        super(values);
    }

    @Override
    public String getLicenseVersion() {
        return VERSION;
    }

    @Override
    public List<LicenseProperty> getLicenseProperties() {
        return Lists.newArrayList(LICENSE_VERSION, PRODUCT, LICENSED_TO, CONTACT, REPOSITORY_ID, EXPIRES_AFTER,
                MAX_NUMBER_OF_USERS, MAX_NUMBER_OF_CIS, LICENSED_PLUGINS, SUPPORT_POLICY);
    }
}
