package com.xebialabs.deployit.plugin.osb.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.osb.ci.OsbCustomizationFile;
import com.xebialabs.deployit.plugin.osb.ci.OsbDomain;
import com.xebialabs.deployit.plugin.osb.ci.OsbJar;
import com.xebialabs.deployit.plugin.osb.ci.OsbJarMapping;
import com.xebialabs.deployit.plugin.osb.step.DeleteOsbProjectStep;
import com.xebialabs.deployit.plugin.osb.step.ImportOsbConfigurationStep;

public class OsbJarToOsbDomainMapper extends StepGeneratingMapper<OsbJar, OsbJarMapping, OsbDomain> {

	public OsbJarToOsbDomainMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(OsbJar newSource, OsbJarMapping newMapping, OsbDomain newTarget,
			List<Step> steps) {
		if (newTarget.getOsbHome() == null) {
			return;
		}
		if (newMapping.getOsbCustomizationFile() == null) {
			steps.add(new ImportOsbConfigurationStep(newTarget, newSource));
		} else {
			OsbCustomizationFile target = (OsbCustomizationFile) newMapping.getOsbCustomizationFile();
			
			steps.add(new ImportOsbConfigurationStep(newTarget, newSource, target.getLocation(),KeyValuePair.toMap(newMapping.getKeyValuePairs())));
		}
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(OsbJar oldSource, OsbJarMapping oldMapping, OsbDomain oldTarget,
			List<Step> steps) {
		steps.add(new DeleteOsbProjectStep(oldTarget, oldSource));
	}
}
