package com.xebialabs.deployit.plugin.osb.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.osb.ci.OsbJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import com.xebialabs.deployit.steps.CopyStep;

@SuppressWarnings("serial")
public class ImportOsbConfigurationStep extends WlsStepBase {

	static final String WLST_SCRIPT_DIRECTORY = "com/xebialabs/deployit/plugin/osb/step/";
	static final String DEPLOY_CONFIGURATION_ON_OSB_SCRIPT_NAME = WLST_SCRIPT_DIRECTORY + "import-osb-configuration-3.0.py";
	private static final String OSB_JAR_EXTENSION = ".jar";

	private String applicationLocation;
	private String applicationName;
	private String extension;
	private String project;
	private String customFile;
	protected Map<String, String> properties;

	public ImportOsbConfigurationStep(WlsDomain domain, OsbJar application, String customFile, Map<String, String> properties) {
		this(domain, application);
		this.customFile = customFile;
		this.properties = properties;
		if (properties == null || properties.isEmpty())
			setDescription("Import OSB Project " + this.project + " on " + domain + " using customization file ");
		else
			setDescription("Import OSB Project " + this.project + " on " + domain
					+ " using customization file and properties replacement");
	}

	public ImportOsbConfigurationStep(WlsDomain domain, OsbJar application) {
		super(domain);
		this.applicationLocation = application.getLocation();
		this.applicationName = application.getName();
		this.extension = OSB_JAR_EXTENSION;
		this.project = application.getProjectName();
		setDescription("Import OSB Project " + this.project + " on " + domain);
	}

	String getProject() {
		return project;
	}

	public String getCustomFile() {
		return customFile;
	}

	private HostFile uploadApplication(HostSession rhs) {
		HostFile uploadedApplicationFile;
		HostSession lhs = HostSessionFactory.getHostSession(Host.getLocalHost());
		HostFile applicationFileToUpload = lhs.getFile(applicationLocation);
		try {
			uploadedApplicationFile = rhs.getTempFile(applicationName, extension);
			HostFileUtils.copy(applicationFileToUpload, uploadedApplicationFile);
		} finally {
			lhs.close();
		}
		return uploadedApplicationFile;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = domain.connectToAdminHost();
		try {
			HostFile uploadedApplication = uploadApplication(rhs);
			String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');

			List<String> argsList = new ArrayList<String>();
			argsList.add(domain.getUsername());
			argsList.add(domain.getPassword());
			argsList.add(domain.getConnectUrl());
			argsList.add(getProject());
			argsList.add(uploadedApplicationPath);

			if (getCustomFile() != null) {
				HostFile tempFile = rhs.getTempFile(applicationName, ".xml");
				String path = tempFile.getPath();
				new CopyStep(Host.getLocalHost(), customFile, domain.getActiveHost(), path, this.properties)
						.execute(ctx);
				argsList.add(path);
			}
			String[] args = argsList.toArray(new String[argsList.size()]);
			int res = executeWlstJythonScriptResource(ctx, rhs, DEPLOY_CONFIGURATION_ON_OSB_SCRIPT_NAME, args);
			return res == 0;

		} finally {
			rhs.close();
		}
	}

}
