/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.osb.ci.OsbCustomizationFile;
import com.xebialabs.deployit.plugin.osb.ci.OsbDomain;
import com.xebialabs.deployit.plugin.osb.ci.OsbJar;
import com.xebialabs.deployit.plugin.osb.ci.OsbJarMapping;
import com.xebialabs.deployit.plugin.osb.step.DeleteOsbProjectStep;
import com.xebialabs.deployit.plugin.osb.step.ImportOsbConfigurationStep;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsbJarToOsbDomainMapper
extends StepGeneratingMapper<OsbJar, OsbJarMapping, OsbDomain> {
    public OsbJarToOsbDomainMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(OsbJar newSource, OsbJarMapping newMapping, OsbDomain newTarget, List<Step> steps) {
        if (newTarget.getOsbHome() == null) {
            return;
        }
        if (newMapping.getOsbCustomizationFile() == null) {
            steps.add((Step)new ImportOsbConfigurationStep(newTarget, newSource));
        } else {
            OsbCustomizationFile target = newMapping.getOsbCustomizationFile();
            steps.add((Step)new ImportOsbConfigurationStep(newTarget, newSource, target.getLocation(), KeyValuePair.toMap((List)newMapping.getKeyValuePairs())));
        }
    }

    protected void generateDeletionStepsForDeletedMapping(OsbJar oldSource, OsbJarMapping oldMapping, OsbDomain oldTarget, List<Step> steps) {
        steps.add((Step)new DeleteOsbProjectStep(oldTarget, oldSource));
    }
}

