/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.osb.runbook;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.osb.mapper.OsbJarToOsbDomainMapper;
import com.xebialabs.deployit.plugin.wls.runbook.WlsDeploymentRunBook;

/**
 * In addition to supporting the standard scenarios covered by {@link WlsDeploymentRunBook}, it supports 
 * the import with customization,re- and deletion of a OSB jar to a {@link com.xebialabs.deployit.plugin.osb.ci.OsbDomain}. The import OSB jar steps 
 * are generated after the steps generated from {@link WlsDeploymentRunBook}. Similarly, the deletion steps for the OSB jar are generated before any from 
 * the {@link WlsDeploymentRunBook}
 * 
 * <h4>Conditions</h4>
 * 
 * This runbook will trigger if the change plan contains the
 * 
 * <ul>
 * <li>addition of a new {@link Deployment} CI
 * <li>modification of an existing {@code Deployment} CI
 * <li>deletion of an existing {@code Deployment} CI
 * </ul>
 * 
 * where the <strong>deployment package contains OSB jars in addition to any other(optional) WLS resources</strong>.
 * <p>
 * The runbook will also handle changes to some properties of {@link com.xebialabs.deployit.plugin.wls.ci.WlsServer Managed Servers} <u>to which a resource has been targeted in the current
 * change plan</u>. Please refer to the {@link WlsDeploymentRunBook} for more details.
 * 
 * Modification of <em>other</em> properties of Managed Servers, or of servers which are <em>not</em> targeted by the current deployment, are <strong>not
 * supported</strong>.
 * <h4>Update Semantics</h4>
 * 
 * Please refer to the {@link WlsDeploymentRunBook update semantics}, they 
 * the applicable for OsbDeploymentRunbook as well.
 * 
 * <h4>Actions</h4>
 * 
 * TODO: Step sequence. Note that JMS Queues are not deleted if non-empty.
 */
public class OsbDeploymentRunbook extends WlsDeploymentRunBook {

	@Override
	protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
		OsbJarToOsbDomainMapper osbjarmapper = new OsbJarToOsbDomainMapper(change);
		osbjarmapper.generateDeletionSteps(steps);
		super.resolve(change, changePlan, steps);
		osbjarmapper.generateAdditionSteps(steps);
	}

}
