/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.importer.Exploder;
import com.xebialabs.deployit.service.importer.Imploder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class PojoConverter
implements InitializingBean {
    public static final String IGNORE_PLACEHOLDER = "<ignore>";
    public static final String EMPTY_PLACEHOLDER = "<empty>";
    public static final String NO_ARTIFACT_DATA_LOCATION = "no-artifact-data";
    private final ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private final RepositoryService repositoryService;
    private File workDir;
    private static final Logger logger = LoggerFactory.getLogger(PojoConverter.class);

    @Autowired
    public PojoConverter(ConfigurationItemTypeDescriptorRepository descriptorRepository, RepositoryService repositoryService) {
        this.descriptorRepository = descriptorRepository;
        this.repositoryService = repositoryService;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.workDir.mkdirs() && !this.workDir.exists()) {
            throw new RuntimeIOException("Cannot create work dir " + this.workDir);
        }
    }

    public Context getContext() {
        return new Context();
    }

    public <T> ConfigurationItemEntity toEntity(T item) {
        return new Context().toEntity(item);
    }

    public <F, G extends ConfigurationItemEntity> List<G> toEntity(List<F> items) {
        return new Context().toEntity(items);
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public class Context {
        private Map<String, Object> convertedPojos = Maps.newHashMap();

        private Context() {
        }

        public <T> T toPojo(ConfigurationItemEntity item) {
            if (this.convertedPojos.containsKey(item.getId())) {
                logger.debug("Returning previously generated POJO for configuration item {}", (Object)item.getId());
                return (T)this.convertedPojos.get(item.getId());
            }
            logger.debug("Reading {}", (Object)item.getId());
            ConfigurationItemDescriptor descriptor = PojoConverter.this.descriptorRepository.getDescriptorByType(item.getConfigurationItemTypeName());
            Object pojo = descriptor.newInstance();
            this.storeReferenceToPojo(item, pojo);
            this.fillLabel(pojo, item, descriptor);
            this.fillArchetypeFields(pojo, item.getConfigurationItemArchetype(), descriptor);
            this.fillFields(pojo, item, descriptor);
            if (item instanceof ArtifactEntity) {
                this.fillArtifactData(pojo, (ArtifactEntity)item, descriptor);
            }
            return (T)pojo;
        }

        private void storeReferenceToPojo(ConfigurationItemEntity item, Object pojo) {
            this.convertedPojos.put(item.getId(), pojo);
        }

        public <F extends ConfigurationItemEntity, G> Collection<G> toPojo(Collection<F> entities) {
            return Collections2.transform(entities, (Function)new Function<F, G>(){

                public G apply(F from) {
                    return Context.this.toPojo((ConfigurationItemEntity)from);
                }
            });
        }

        private void fillLabel(Object o, ConfigurationItemEntity item, ConfigurationItemDescriptor descriptor) {
            descriptor.setLabelValueInConfigurationItem(o, item.getId());
        }

        private void fillArchetypeFields(Object o, ArchetypeEntity configurationItemArchetype, ConfigurationItemDescriptor descriptor) {
            if (configurationItemArchetype != null) {
                this.fillArchetypeFields(o, configurationItemArchetype.getConfigurationItemArchetype(), descriptor);
                this.fillFields(o, configurationItemArchetype, descriptor);
            }
        }

        private void fillFields(Object o, RepositoryObjectEntity item, ConfigurationItemDescriptor descriptor) {
            ConfigurationItemPropertyDescriptor[] descriptors;
            for (ConfigurationItemPropertyDescriptor propertyDescriptor : descriptors = descriptor.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(descriptor.getPlaceholdersName())) {
                    this.fillProperty(o, item, propertyDescriptor);
                    continue;
                }
                this.fillPlaceholders(o, item, propertyDescriptor);
            }
        }

        private void fillPlaceholders(Object o, RepositoryObjectEntity item, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            Collection placeholders = (Collection)item.getValue(propertyDescriptor.getName());
            ArrayList pojoPlaceholders = Lists.newArrayList();
            if (placeholders != null) {
                for (Map placeholder : placeholders) {
                    String key = (String)placeholder.get("key");
                    String value = (String)placeholder.get("value");
                    if (value.equals(PojoConverter.IGNORE_PLACEHOLDER)) continue;
                    KeyValuePair pair = new KeyValuePair(key, value.equals(PojoConverter.EMPTY_PLACEHOLDER) ? "" : value);
                    pojoPlaceholders.add(pair);
                }
            }
            propertyDescriptor.setPropertyValueInConfigurationItem(o, (Object)pojoPlaceholders);
        }

        private void fillProperty(Object o, RepositoryObjectEntity item, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            String propertyName = propertyDescriptor.getName();
            Object itemValue = item.getValue(propertyName);
            this.fillPropertyValue(o, itemValue, propertyDescriptor);
        }

        private void fillPropertyValue(Object o, Object itemValue, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            Object value = null;
            if (itemValue == null) {
                return;
            }
            switch (propertyDescriptor.getType()) {
                case STRING: {
                    value = itemValue;
                    break;
                }
                case BOOLEAN: {
                    value = Boolean.valueOf((String)((Object)itemValue));
                    break;
                }
                case INTEGER: {
                    value = Integer.valueOf((String)((Object)itemValue));
                    break;
                }
                case ENUM: {
                    value = this.handleEnumValue(propertyDescriptor, (String)((Object)itemValue));
                    break;
                }
                case LIST_OF_OBJECTS: {
                    value = this.handleListOfObjects(propertyDescriptor, itemValue);
                    break;
                }
                case SET_OF_STRINGS: {
                    value = this.handleSetOfString(itemValue);
                    break;
                }
                case CI: {
                    logger.debug("Loading {} of {} with value {}", new Object[]{propertyDescriptor.getName(), o, itemValue});
                    value = this.handleConfigurationItem((String)((Object)itemValue));
                    break;
                }
                case SET_OF_CIS: {
                    logger.debug("Loading {} of {} with value {}", new Object[]{propertyDescriptor.getName(), o, itemValue});
                    value = this.handleSetofConfigurationItems((Collection<String>)itemValue);
                    break;
                }
                case UNSUPPORTED: {
                    throw new IllegalStateException("An UNSUPPORTED PropertyDescriptor should not be present! Call in the bug-hunters!");
                }
            }
            propertyDescriptor.setPropertyValueInConfigurationItem(o, value);
        }

        private Set<String> handleSetOfString(Object itemValue) {
            if (itemValue instanceof Set) {
                return (Set)itemValue;
            }
            if (itemValue instanceof Collection) {
                return Sets.newHashSet((Iterable)((Collection)itemValue));
            }
            throw new IllegalStateException("Didn't get a Set of String or other Collection type.");
        }

        private Object handleSetofConfigurationItems(Collection<String> ids) {
            HashSet result = Sets.newHashSet();
            for (String id : ids) {
                result.add(this.handleConfigurationItem(id));
            }
            return result;
        }

        private Object handleConfigurationItem(String id) {
            if (this.convertedPojos.containsKey(id)) {
                return this.convertedPojos.get(id);
            }
            ConfigurationItemEntity ci = (ConfigurationItemEntity)PojoConverter.this.repositoryService.readFully(id);
            return this.toPojo(ci);
        }

        private List<Object> handleListOfObjects(ConfigurationItemPropertyDescriptor propertyDescriptor, Object itemValue) {
            ArrayList result = Lists.newArrayList();
            for (Map each : (List)itemValue) {
                Object o;
                try {
                    o = propertyDescriptor.getCollectionMemberClass().newInstance();
                }
                catch (Exception exc) {
                    throw new IllegalStateException("Unable to instantiate type " + propertyDescriptor.getCollectionMemberClassname() + ": " + exc.getMessage());
                }
                for (ConfigurationItemPropertyDescriptor eachProp : propertyDescriptor.getListObjectPropertyDescriptors()) {
                    this.fillPropertyValue(o, each.get(eachProp.getName()), eachProp);
                }
                result.add(o);
            }
            return result;
        }

        private Object handleEnumValue(ConfigurationItemPropertyDescriptor propertyDescriptor, String value) {
            Class propertyClass = propertyDescriptor.getPropertyClass();
            return Enum.valueOf(propertyClass, value);
        }

        private void fillArtifactData(Object o, ArtifactEntity item, ConfigurationItemDescriptor descriptor) {
            if (item.getData() == null) {
                logger.warn("Not filling in the artifact data, because it wasn't set.");
                return;
            }
            if (o instanceof Folder) {
                DeployableArtifact da = (DeployableArtifact)o;
                da.setLocation(this.writeArtifactDataToTemporaryFolder(item).getPath());
            } else if (o instanceof DeployableArtifact) {
                DeployableArtifact da = (DeployableArtifact)o;
                da.setLocation(this.writeArtifactDataToTemporaryFile(item).getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File writeArtifactDataToTemporaryFile(ArtifactEntity item) {
            try {
                logger.debug("Writing data for artifact {} to temporary file in work directory {}", (Object)item.getId(), (Object)PojoConverter.this.workDir);
                File artifactDataFile = File.createTempFile(item.getId().replace('/', '_'), ".tmp", PojoConverter.this.workDir);
                FileOutputStream artifactDataOut = new FileOutputStream(artifactDataFile);
                try {
                    InputStream artifactDataIn = item.getData();
                    try {
                        IOUtils.copy((InputStream)artifactDataIn, (OutputStream)artifactDataOut);
                    }
                    finally {
                        artifactDataIn.close();
                    }
                }
                finally {
                    artifactDataOut.close();
                }
                logger.debug("Wrote data for artifact {} to file {} in work directory", (Object)item.getId(), (Object)artifactDataFile.getPath());
                return artifactDataFile;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot write artifact data to temporary file for artifact " + item.getId(), (Throwable)exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File writeArtifactDataToTemporaryFolder(ArtifactEntity item) {
            File file;
            InputStream artifactDataIn = item.getData();
            try {
                logger.debug("Exploding folder artifact {} to temporary directory work directory {}", (Object)item.getId(), (Object)PojoConverter.this.workDir);
                File artifactDataFolder = Exploder.explode(artifactDataIn);
                logger.debug("Exploded folder artifact {} to directory {} in work directory", (Object)item.getId(), (Object)artifactDataFolder);
                file = artifactDataFolder;
            }
            catch (Throwable throwable) {
                try {
                    artifactDataIn.close();
                    throw throwable;
                }
                catch (IOException exc) {
                    throw new RuntimeIOException("Cannot write artifact data to temporary folder for artifact " + item.getId(), (Throwable)exc);
                }
            }
            artifactDataIn.close();
            return file;
        }

        public void destroy() {
            for (Object each : this.convertedPojos.values()) {
                if (!(each instanceof DeployableArtifact)) continue;
                this.cleanupArtifactData((DeployableArtifact)each);
            }
            this.convertedPojos.clear();
        }

        private void cleanupArtifactData(DeployableArtifact artifact) {
            Checks.checkNotNull(artifact.getLocation(), "Location of artifact is null");
            if (PojoConverter.NO_ARTIFACT_DATA_LOCATION.equals(artifact.getLocation())) {
                logger.debug("Not cleaning up artifact data for {} because it has already been cleaned up", (Object)artifact);
                return;
            }
            File artifactData = new File(artifact.getLocation());
            artifact.setLocation(PojoConverter.NO_ARTIFACT_DATA_LOCATION);
            if (artifactData.exists()) {
                if (artifactData.isDirectory()) {
                    try {
                        logger.debug("Deleting artifact data folder {} for artifact {}", (Object)artifactData, (Object)artifact);
                        FileUtils.deleteDirectory((File)artifactData);
                        logger.debug("Deleted artifact data folder {} for artifact {}", (Object)artifactData, (Object)artifact);
                    }
                    catch (IOException exc) {
                        logger.warn("Cannot delete artifact data folder {} for artifact {} temporarily exported for {}", (Object)artifactData, (Object)artifact);
                    }
                } else {
                    logger.debug("Deleting artifact data file {} for artifact {}", (Object)artifactData, (Object)artifact);
                    if (!artifactData.delete()) {
                        logger.warn("Cannot delete artifact data file {} for artifact {} temporarily exported for {}", (Object)artifactData, (Object)artifact);
                    }
                    logger.debug("Deleted artifact data file {} for artifact {}", (Object)artifactData, (Object)artifact);
                }
            } else {
                logger.debug("Not cleaning up artifact data for artifact {} because the location {} no longer exists", (Object)artifactData);
            }
        }

        public <T> ConfigurationItemEntity toEntity(T item) {
            ConfigurationItemEntity entity = item instanceof DeployableArtifact ? new ArtifactEntity(item.getClass().getName()) : new ConfigurationItemEntity(item.getClass().getName());
            this.setLabel(item, entity);
            this.putProperties(item, entity);
            this.putPlaceholders(item, entity);
            if (item instanceof DeployableArtifact) {
                this.setData((DeployableArtifact)item, entity);
            }
            return entity;
        }

        public <F, G extends ConfigurationItemEntity> List<G> toEntity(List<F> items) {
            ArrayList entities = Lists.newArrayList();
            for (F each : items) {
                entities.add(this.toEntity(each));
            }
            return entities;
        }

        private <T> void setLabel(T item, ConfigurationItemEntity entity) {
            String id = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(entity).getLabelValueFromConfigurationItem(item);
            entity.setId(id);
        }

        private <T> void putProperties(T item, ConfigurationItemEntity entity) {
            for (ConfigurationItemPropertyDescriptor each : ConfigurationItemDescriptorRepositoryHolder.getDescriptor(entity).getPropertyDescriptors()) {
                this.putProperty(item, entity, each);
            }
        }

        private <T> void putPlaceholders(T item, ConfigurationItemEntity entity) {
            ConfigurationItemDescriptor descriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(entity);
            Field placeholderField = descriptor.getPlaceholdersField();
            if (placeholderField != null) {
                try {
                    List p = (List)placeholderField.get(item);
                    ArrayList placeholders = Lists.newArrayList();
                    for (KeyValuePair keyValuePair : p) {
                        HashMap placeholder = Maps.newHashMap();
                        placeholder.put("key", keyValuePair.getKey());
                        placeholder.put("value", keyValuePair.getValue());
                        placeholders.add(placeholder);
                    }
                    entity.addValue(descriptor.getPlaceholdersName(), placeholders);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Should be able to access the placeholderField", e);
                }
            }
        }

        private <T> void putProperty(T item, ConfigurationItemEntity entity, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            Object valueForEntity = this.getValue(item, propertyDescriptor);
            if (valueForEntity != null) {
                entity.addValue(propertyDescriptor.getName(), valueForEntity);
            }
        }

        private <T> Object getValue(T item, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            Object valueForEntity = null;
            switch (propertyDescriptor.getType()) {
                case STRING: 
                case BOOLEAN: 
                case INTEGER: 
                case ENUM: {
                    Object valueFromItem = propertyDescriptor.getPropertyValueFromConfigurationItem(item);
                    if (valueFromItem == null) break;
                    valueForEntity = valueFromItem.toString();
                    break;
                }
                case SET_OF_STRINGS: {
                    valueForEntity = propertyDescriptor.getPropertyValueFromConfigurationItem(item);
                    break;
                }
                case CI: {
                    Object referencedCi = propertyDescriptor.getPropertyValueFromConfigurationItem(item);
                    if (referencedCi == null) break;
                    valueForEntity = this.getLabelFromConfigurationItem(referencedCi);
                    break;
                }
                case SET_OF_CIS: {
                    Set referencedCis = (Set)propertyDescriptor.getPropertyValueFromConfigurationItem(item);
                    HashSet result = Sets.newHashSet();
                    if (referencedCis != null) {
                        for (Object each : referencedCis) {
                            result.add(this.getLabelFromConfigurationItem(each));
                        }
                    }
                    valueForEntity = result;
                    break;
                }
                case LIST_OF_OBJECTS: {
                    List listOfObjects = (List)propertyDescriptor.getPropertyValueFromConfigurationItem(item);
                    ArrayList listofObjects = Lists.newArrayList();
                    if (listOfObjects != null) {
                        ConfigurationItemPropertyDescriptor[] nestedPropertyDescriptors = propertyDescriptor.getListObjectPropertyDescriptors();
                        for (Object each : listOfObjects) {
                            HashMap objectValues = Maps.newHashMap();
                            for (ConfigurationItemPropertyDescriptor eachProp : nestedPropertyDescriptors) {
                                Object propValue = this.getValue(each, eachProp);
                                if (propValue == null) continue;
                                objectValues.put(eachProp.getName(), propValue.toString());
                            }
                            listofObjects.add(objectValues);
                        }
                    }
                    valueForEntity = listofObjects;
                }
            }
            return valueForEntity;
        }

        private String getLabelFromConfigurationItem(Object ci) {
            ConfigurationItemDescriptor referencedCiDescriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptorRepository().getDescriptorByClass(ci.getClass());
            return referencedCiDescriptor.getLabelValueFromConfigurationItem(ci);
        }

        private <T extends DeployableArtifact> void setData(T item, ConfigurationItemEntity entity) {
            if (item.getLocation() == null) {
                return;
            }
            if (item instanceof Folder) {
                this.setFolderData((Folder)item, (ArtifactEntity)entity);
            } else {
                this.setFileData(item, (ArtifactEntity)entity);
            }
        }

        private <T extends Folder> void setFolderData(T item, ArtifactEntity entity) {
            try {
                byte[] implodedFolderData = Imploder.implode(new File(item.getLocation()));
                entity.setData(new ByteArrayInputStream(implodedFolderData));
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot read artifact folder data from " + item, (Throwable)exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends DeployableArtifact> void setFileData(T item, ArtifactEntity entity) {
            try {
                FileInputStream dataIn = new FileInputStream(item.getLocation());
                try {
                    byte[] artifactData = IOUtils.toByteArray((InputStream)dataIn);
                    entity.setData(new ByteArrayInputStream(artifactData));
                }
                finally {
                    dataIn.close();
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot read artifact file data from " + item, (Throwable)exc);
            }
        }
    }
}

