/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.List;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeStateEx {
    private NodeState nodeState;
    private final UpdatableItemStateManager stateMgr;
    private final NodeTypeRegistry ntReg;
    private Name name;
    private QNodeDefinition def;

    public NodeStateEx(UpdatableItemStateManager stateMgr, NodeTypeRegistry ntReg, NodeState nodeState, Name name) {
        this.nodeState = nodeState;
        this.ntReg = ntReg;
        this.stateMgr = stateMgr;
        this.name = name;
    }

    public NodeStateEx(UpdatableItemStateManager stateMgr, NodeTypeRegistry ntReg, NodeId nodeId) throws RepositoryException {
        try {
            this.ntReg = ntReg;
            this.stateMgr = stateMgr;
            this.nodeState = (NodeState)stateMgr.getItemState(nodeId);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Name getName() {
        if (this.name == null) {
            try {
                NodeId parentId = this.nodeState.getParentId();
                NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
                this.name = parent.getChildNodeEntry(this.nodeState.getNodeId()).getName();
            }
            catch (ItemStateException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return this.name;
    }

    public NodeId getNodeId() {
        return this.nodeState.getNodeId();
    }

    public NodeId getParentId() {
        return this.nodeState.getParentId();
    }

    public NodeStateEx getParent() throws RepositoryException {
        if (this.nodeState.getParentId() == null) {
            return null;
        }
        return this.getNode(this.nodeState.getParentId());
    }

    public NodeState getState() {
        return this.nodeState;
    }

    public PropertyState[] getProperties() throws ItemStateException {
        Set<Name> set = this.nodeState.getPropertyNames();
        PropertyState[] props = new PropertyState[set.size()];
        int i = 0;
        for (Name propName : set) {
            PropertyId propId = new PropertyId(this.nodeState.getNodeId(), propName);
            props[i++] = (PropertyState)this.stateMgr.getItemState(propId);
        }
        return props;
    }

    public boolean hasProperty(Name name) {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        return this.stateMgr.hasItemState(propId);
    }

    public InternalValue[] getPropertyValues(Name name) {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        try {
            PropertyState ps = (PropertyState)this.stateMgr.getItemState(propId);
            return ps.getValues();
        }
        catch (ItemStateException e) {
            return null;
        }
    }

    public InternalValue getPropertyValue(Name name) {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        try {
            PropertyState ps = (PropertyState)this.stateMgr.getItemState(propId);
            return ps.getValues()[0];
        }
        catch (ItemStateException e) {
            return null;
        }
    }

    public void setPropertyValue(Name name, InternalValue value) throws RepositoryException {
        this.setPropertyValues(name, value.getType(), new InternalValue[]{value}, false);
    }

    public void setPropertyValues(Name name, int type, InternalValue[] values) throws RepositoryException {
        this.setPropertyValues(name, type, values, true);
    }

    public PropertyState setPropertyValues(Name name, int type, InternalValue[] values, boolean multiple) throws RepositoryException {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        if (this.stateMgr.hasItemState(propId)) {
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
                if (propState.getStatus() == 1) {
                    propState.setStatus(2);
                }
                if (this.nodeState.getStatus() == 1) {
                    this.nodeState.setStatus(2);
                }
                propState.setType(type);
                propState.setValues(values);
                return propState;
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Unable to create property: " + e.toString());
            }
        }
        PropertyState propState = this.stateMgr.createNew(name, this.nodeState.getNodeId());
        propState.setType(type);
        propState.setMultiValued(multiple);
        propState.setValues(values);
        this.nodeState.addPropertyName(name);
        if (this.nodeState.getStatus() == 1) {
            this.nodeState.setStatus(2);
        }
        return propState;
    }

    public EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        try {
            return this.ntReg.getEffectiveNodeType(this.nodeState.getNodeTypeName(), this.nodeState.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + this.nodeState.getNodeId();
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    public boolean hasNode(Name name) {
        return this.nodeState.hasChildNodeEntry(name);
    }

    public boolean removeNode(Name name) throws RepositoryException {
        return this.removeNode(name, 1);
    }

    public boolean removeNode(NodeStateEx node) throws RepositoryException {
        return this.removeNode(this.nodeState.getChildNodeEntry(node.getNodeId()));
    }

    public boolean removeNode(Name name, int index) throws RepositoryException {
        return this.removeNode(this.nodeState.getChildNodeEntry(name, index));
    }

    public boolean removeNode(ChildNodeEntry entry) throws RepositoryException {
        try {
            if (entry == null) {
                return false;
            }
            this.removeNode(entry.getId());
            this.nodeState.removeChildNodeEntry(entry.getId());
            this.nodeState.setStatus(2);
            return true;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void removeNode(NodeId id) throws ItemStateException {
        NodeState state = (NodeState)this.stateMgr.getItemState(id);
        for (Name name : state.getPropertyNames()) {
            PropertyId propId = new PropertyId(id, name);
            PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
            this.stateMgr.destroy(propState);
        }
        state.removeAllPropertyNames();
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            this.removeNode(entry.getId());
        }
        state.removeAllChildNodeEntries();
        this.stateMgr.destroy(state);
    }

    public boolean removeProperty(Name name) throws RepositoryException {
        try {
            if (!this.nodeState.hasPropertyName(name)) {
                return false;
            }
            PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
            ItemState state = this.stateMgr.getItemState(propId);
            this.stateMgr.destroy(state);
            this.nodeState.removePropertyName(name);
            this.nodeState.setStatus(2);
            return true;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public NodeStateEx getNode(Name name, int index) throws RepositoryException {
        ChildNodeEntry entry = this.nodeState.getChildNodeEntry(name, index);
        if (entry == null) {
            return null;
        }
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(entry.getId());
            return new NodeStateEx(this.stateMgr, this.ntReg, state, name);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to getNode: " + e.toString());
        }
    }

    public NodeStateEx getNode(NodeId id) throws RepositoryException {
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(id);
            return new NodeStateEx(this.stateMgr, this.ntReg, state, this.name);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to getNode: " + e.toString());
        }
    }

    public boolean hasNode(NodeId id) {
        return this.stateMgr.hasItemState(id);
    }

    public boolean hasProperty(PropertyId id) {
        return this.stateMgr.hasItemState(id);
    }

    public NodeStateEx addNode(Name nodeName, Name nodeTypeName, NodeId id) throws NoSuchNodeTypeException, ConstraintViolationException, RepositoryException {
        return this.addNode(nodeName, nodeTypeName, id, this.ntReg.getEffectiveNodeType(nodeTypeName).includesNodeType(NameConstants.MIX_REFERENCEABLE));
    }

    public NodeStateEx addNode(Name nodeName, Name nodeTypeName, NodeId id, boolean referenceable) throws NoSuchNodeTypeException, ConstraintViolationException, RepositoryException {
        NodeStateEx node = this.createChildNode(nodeName, nodeTypeName, id);
        if (referenceable) {
            node.setPropertyValue(NameConstants.JCR_UUID, InternalValue.create(node.getNodeId().toString()));
        }
        return node;
    }

    public void setMixins(Set<Name> mixinTypeNames) throws RepositoryException {
        this.nodeState.setMixinTypeNames(mixinTypeNames);
        this.setPropertyValues(NameConstants.JCR_MIXINTYPES, 7, InternalValue.create(mixinTypeNames.toArray(new Name[mixinTypeNames.size()])));
    }

    private NodeStateEx createChildNode(Name name, Name nodeTypeName, NodeId id) throws RepositoryException {
        NodeId parentId = this.nodeState.getNodeId();
        if (id == null) {
            id = new NodeId();
        }
        NodeState state = this.stateMgr.createNew(id, nodeTypeName, parentId);
        NodeStateEx node = new NodeStateEx(this.stateMgr, this.ntReg, state, name);
        node.setPropertyValue(NameConstants.JCR_PRIMARYTYPE, InternalValue.create(nodeTypeName));
        this.nodeState.addChildNodeEntry(name, id);
        if (this.nodeState.getStatus() == 1) {
            this.nodeState.setStatus(2);
        }
        return node;
    }

    public NodeStateEx moveFrom(NodeStateEx src, Name name, boolean createShare) throws RepositoryException {
        QNodeDefinition def;
        if (name == null) {
            name = src.getName();
        }
        EffectiveNodeType ent = this.getEffectiveNodeType();
        try {
            def = ent.getApplicableChildNodeDef(name, this.nodeState.getNodeTypeName(), this.ntReg);
        }
        catch (RepositoryException re) {
            String msg = "no definition found in parent node's node type for new node";
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        ChildNodeEntry cne = this.nodeState.getChildNodeEntry(name, 1);
        if (cne != null) {
            NodeState existingChild;
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException(this.getNodeId() + "/" + name);
            }
            try {
                existingChild = (NodeState)this.stateMgr.getItemState(cne.getId());
            }
            catch (ItemStateException e) {
                throw new RepositoryException((Throwable)e);
            }
            QNodeDefinition existingChildDef = ent.getApplicableChildNodeDef(cne.getName(), existingChild.getNodeTypeName(), this.ntReg);
            if (!existingChildDef.allowsSameNameSiblings()) {
                throw new ItemExistsException(existingChild.toString());
            }
        } else if (this.getDefinition().isProtected()) {
            String msg = "not allowed to modify a protected node";
            throw new ConstraintViolationException(msg);
        }
        if (createShare) {
            NodeId parentId = this.getNodeId();
            src.addShareParent(parentId);
            this.nodeState.addChildNodeEntry(name, src.getNodeId());
            if (this.nodeState.getStatus() == 1) {
                this.nodeState.setStatus(2);
            }
            return new NodeStateEx(this.stateMgr, this.ntReg, src.getState(), name);
        }
        NodeStateEx parent = this.getNode(src.getParentId());
        parent.nodeState.removeChildNodeEntry(src.getNodeId());
        if (parent.nodeState.getStatus() == 1) {
            parent.nodeState.setStatus(2);
        }
        this.nodeState.addChildNodeEntry(name, src.getNodeId());
        if (this.nodeState.getStatus() == 1) {
            this.nodeState.setStatus(2);
        }
        NodeState srcState = src.getState();
        srcState.setParentId(this.getNodeId());
        if (srcState.getStatus() == 1) {
            srcState.setStatus(2);
        }
        return new NodeStateEx(this.stateMgr, this.ntReg, srcState, name);
    }

    private void addShareParent(NodeId parentId) throws RepositoryException {
        if (!this.nodeState.isShareable()) {
            String msg = this + " is not shareable.";
            throw new RepositoryException(msg);
        }
        if (!this.nodeState.containsShare(parentId) && this.nodeState.addShare(parentId)) {
            return;
        }
        String msg = "Adding a shareable node twice to the same parent is not supported.";
        throw new UnsupportedRepositoryOperationException(msg);
    }

    public NodeStateEx[] getChildNodes() throws RepositoryException {
        try {
            List<ChildNodeEntry> entries = this.nodeState.getChildNodeEntries();
            NodeStateEx[] children = new NodeStateEx[entries.size()];
            int i = 0;
            for (ChildNodeEntry entry : entries) {
                NodeState state = (NodeState)this.stateMgr.getItemState(entry.getId());
                children[i++] = new NodeStateEx(this.stateMgr, this.ntReg, state, entry.getName());
            }
            return children;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void store() throws RepositoryException {
        try {
            this.store(this.nodeState);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void store(NodeState state) throws ItemStateException {
        if (state.getStatus() != 1) {
            for (Name propName : state.getPropertyNames()) {
                PropertyState pstate = (PropertyState)this.stateMgr.getItemState(new PropertyId(state.getNodeId(), propName));
                if (pstate.getStatus() == 1) continue;
                this.stateMgr.store(pstate);
            }
            for (ChildNodeEntry entry : state.getChildNodeEntries()) {
                NodeState nstate = (NodeState)this.stateMgr.getItemState(entry.getId());
                this.store(nstate);
            }
            this.stateMgr.store(state);
        }
    }

    public void reload() throws RepositoryException {
        try {
            this.reload(this.nodeState);
            this.nodeState = (NodeState)this.stateMgr.getItemState(this.nodeState.getNodeId());
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void reload(NodeState state) throws ItemStateException {
        if (state.getStatus() != 1) {
            for (Name propName : state.getPropertyNames()) {
                PropertyState pstate = (PropertyState)this.stateMgr.getItemState(new PropertyId(state.getNodeId(), propName));
                if (pstate.getStatus() == 1) continue;
                pstate.discard();
            }
            for (ChildNodeEntry entry : state.getChildNodeEntries()) {
                NodeState nstate = (NodeState)this.stateMgr.getItemState(entry.getId());
                this.reload(nstate);
            }
            state.discard();
        }
    }

    public void copyFrom(PropertyImpl prop) throws RepositoryException {
        if (prop.isMultiple()) {
            InternalValue[] values = prop.internalGetValues();
            InternalValue[] copiedValues = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                copiedValues[i] = values[i].createCopy();
            }
            this.setPropertyValues(prop.getQName(), prop.getType(), copiedValues);
        } else {
            this.setPropertyValue(prop.getQName(), prop.internalGetValue().createCopy());
        }
    }

    public void copyFrom(PropertyState prop) throws RepositoryException {
        InternalValue[] values = prop.getValues();
        InternalValue[] copiedValues = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            copiedValues[i] = values[i].createCopy();
        }
        this.setPropertyValues(prop.getName(), prop.getType(), copiedValues, prop.isMultiValued());
    }

    public QNodeDefinition getDefinition() throws RepositoryException {
        if (this.def == null) {
            EffectiveNodeType ent = this.getParent().getEffectiveNodeType();
            this.def = ent.getApplicableChildNodeDef(this.getName(), this.nodeState.getNodeTypeName(), this.ntReg);
        }
        return this.def;
    }

    public QPropertyDefinition getDefinition(PropertyState prop) throws RepositoryException {
        return this.getEffectiveNodeType().getApplicablePropertyDef(prop.getName(), prop.getType(), prop.isMultiValued());
    }

    public boolean hasAncestor(NodeId nodeId) throws RepositoryException {
        if (nodeId.equals(this.nodeState.getParentId())) {
            return true;
        }
        NodeStateEx parent = this.getParent();
        return parent != null && parent.hasAncestor(nodeId);
    }
}

