#!/bin/sh
#
# Shell script to start the Deployit Server
#

if [ "x$DEPLOYIT_HOME" = "x" ] ; then
  BIN_DIR=`dirname "$0"`
  cd "$BIN_DIR"
  ABSOLUTE_BIN_DIR=`pwd`
  DEPLOYIT_HOME=`dirname "$ABSOLUTE_BIN_DIR"`
fi
echo DEPLOYIT_HOME: $DEPLOYIT_HOME
cd "$DEPLOYIT_HOME"

if [ -z "$JAVA_HOME" ] ; then
  javaExec=java
else
  javaExec=${JAVA_HOME}/bin/java
fi

classpath='conf'
for each in `ls hotfix/*.jar lib/*.jar plugins/*.jar 2>/dev/null`
do
  if [ -f $each ]; then
    classpath=${classpath}:${each}
  fi
done

ls plugins/* > /dev/null 2>&1
if [ $? -eq 0 ]; then
  for expandedPluginDir in `ls plugins/*`
  do
    if [ -d $expandedPluginDir ]; then
      classpath=${classpath}:${expandedPluginDir}
    fi
  done
fi

#SYSPROPS="-Djava.security.auth.login.config=\"$DEPLOYIT_HOME/conf/jackrabbit-jaas.config\""
SYSPROPS="-Dorg.apache.james.mime4j.defaultStorageProvider=org.apache.james.mime4j.storage.MemoryStorageProvider"

$javaExec -Xmx1024m -cp "${classpath}" ${SYSPROPS} com.xebialabs.deployit.DeployIt "$@"
