/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.io.Serializable;
import java.util.HashMap;

public class DestroyWasManagedApacheWebServerStep
extends WasStepBase {
    private static final String DESTROY_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/destroy-was-managed-apache-web-server.py";
    private WasManagedApacheHttpdServer webserver;

    public DestroyWasManagedApacheWebServerStep(WasManagedApacheHttpdServer webserver) {
        super(webserver.getNode().getCell());
        this.webserver = webserver;
        String manegedOrUmanagedDescription = webserver instanceof WasUnManagedApacheHttpdServer ? "unmanaged" : "managed";
        this.setDescription("Destroy WAS " + manegedOrUmanagedDescription + " Apache web server " + (Object)((Object)webserver) + " on node " + webserver.getNode() + " in cell " + webserver.getNode().getCell());
    }

    public boolean execute(StepExecutionContext ctx) {
        int res = this.destroyApacheHttpdServerConfigurationInWas(ctx);
        if (res == 0) {
            this.destroyApacheConfFragmentForWasPlugin(ctx);
        }
        return res == 0;
    }

    private int destroyApacheHttpdServerConfigurationInWas(StepExecutionContext ctx) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("webserver", (Serializable)((Object)this.webserver));
        context.put("node", this.webserver.getNode());
        context.put("cell", this.webserver.getNode().getCell());
        return this.executeWsadminJythonScriptResource(ctx, context, DESTROY_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyApacheConfFragmentForWasPlugin(StepExecutionContext ctx) {
        HostSession rhs = this.webserver.getHost().getHostSession();
        try {
            HostFile fragmentFile = rhs.getFile(this.webserver.getApacheHttpdServerConfigFragmentPath());
            ctx.logOutput("Deleting Apache configuration fragment " + fragmentFile.getPath() + " for WAS plugin");
            fragmentFile.delete();
        }
        finally {
            rhs.close();
        }
    }
}

