/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DescriptorProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.util.ArrayList;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DescriptorResource
implements DescriptorProxy {
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private ConfigurationItemTypeDescriptorRepository descriptorRepository;

    @Override
    public Response list() {
        ConfigurationItemDescriptorList descriptorList = new ConfigurationItemDescriptorList();
        ArrayList<ConfigurationItemDescriptorDto> descriptors = new ArrayList<ConfigurationItemDescriptorDto>();
        for (ConfigurationItemDescriptor descriptor : this.descriptorRepository.getDescriptors()) {
            ConfigurationItemDescriptorDto descriptorDto = this.dtoConverter.toDto(descriptor);
            descriptors.add(descriptorDto);
        }
        descriptorList.setDescriptors(descriptors);
        return ResponseFactory.ok(descriptorList).build();
    }

    @Override
    public Response find(@PathParam(value="type") String type) {
        ConfigurationItemTypeDescriptorRepository descriptorRepository = ConfigurationItemDescriptorRepositoryHolder.getDescriptorRepository();
        ConfigurationItemDescriptor descriptor = descriptorRepository.getDescriptorByType(type);
        ConfigurationItemDescriptorDto dto = this.dtoConverter.toDto(descriptor);
        return ResponseFactory.ok(dto).build();
    }
}

