/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SearchParameterFactory {
    public static SearchParameters createSearchParam(String typeName, boolean archetype, long page, long resultPerPage, List<PropertyValue> values, Date at) {
        SearchParameters searchParameters = SearchParameterFactory.createSearchParam(typeName, archetype, page, resultPerPage, values);
        if (at != null) {
            searchParameters.setAt(at.getCalendar());
        }
        return searchParameters;
    }

    public static SearchParameters createSearchParam(String typeName, boolean archetype, long page, long resultPerPage, List<PropertyValue> values) {
        SearchParameters searchParam = new SearchParameters();
        if (StringUtils.isNotBlank(typeName)) {
            searchParam.setConfigurationItemType(typeName);
        }
        if (archetype) {
            searchParam.setArchetypes();
        } else {
            searchParam.setConfigurationItems();
        }
        searchParam.setPage(page);
        if (resultPerPage != 0L) {
            searchParam.setResultsPerPage(resultPerPage);
        }
        for (PropertyValue value : values) {
            searchParam.addProperty(value.getKey(), value.getValue());
        }
        return searchParam;
    }

    public static SearchParameters createSearchParam(String typeName, boolean archetype, long page, long resultPerPage, List<PropertyValue> values, String parent, String id) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(typeName, archetype, page, resultPerPage, values);
        if (StringUtils.isNotBlank(parent)) {
            searchParam.setParent(parent);
        }
        if (StringUtils.isNotBlank(id)) {
            searchParam.setId(id);
        }
        return searchParam;
    }
}

