/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.TaskProxy;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStep;
import java.util.Calendar;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskResource
extends AbstractSecuredResource
implements TaskProxy {
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    private static final Logger logger = LoggerFactory.getLogger(TaskResource.class);

    @Override
    public Response start(String taskId) {
        this.engine.execute(taskId);
        return ResponseFactory.accepted().build();
    }

    @Override
    public Response cancel(String taskId) {
        this.engine.cancel(taskId);
        return ResponseFactory.status(Response.Status.NO_CONTENT).build();
    }

    @Override
    public Response stop(String taskId) {
        try {
            this.engine.stopExecution(taskId);
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not stop task %s", taskId), ise);
            return ResponseFactory.status(Response.Status.CONFLICT).entity(ise.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    @Override
    public Response abort(String taskId) {
        try {
            this.engine.abortExecution(taskId);
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not abort task %s", taskId), ise);
            return ResponseFactory.status(Response.Status.CONFLICT).entity(ise.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    @Override
    public Response getTaskInfo(String taskId) {
        return ResponseFactory.ok(this.dtoConverter.toDto(taskId, this.engine.getTask(taskId))).build();
    }

    @Override
    public Response toggleSkipSteps(@PathParam(value="taskid") String taskId, @PathParam(value="steps") String stepIds) {
        String[] taskStepIds;
        Task task = this.engine.getTask(taskId);
        for (String stepId : taskStepIds = stepIds.split(",")) {
            int id = Integer.parseInt(stepId);
            TaskStep taskStep = task.getStep(id);
            if (taskStep.canSkip()) {
                logger.info("Skipping step :{}", (Object)taskStep.getDescription());
                taskStep.skip();
                continue;
            }
            if (!taskStep.isSkipped()) continue;
            taskStep.unskip();
        }
        return ResponseFactory.ok(this.dtoConverter.toDto(task)).build();
    }

    @Override
    public Response getStepInfo(String taskId, int stepNr, Date ifModifiedSince) {
        Task task = this.engine.getTask(taskId);
        TaskStep step = task.getStep(stepNr);
        if (this.hasBeenModifiedSince(step, ifModifiedSince)) {
            return ResponseFactory.ok(this.dtoConverter.toDto(stepNr, step)).lastModified(step.getLastModificationDate().getTime()).build();
        }
        return ResponseFactory.notModified().build();
    }

    protected boolean hasBeenModifiedSince(TaskStep step, Date ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        Calendar lastModifiedCal = step.getLastModificationDate();
        lastModifiedCal.set(14, 0);
        return ifModifiedSince.getCalendar().before(lastModifiedCal);
    }

    @Override
    public Response getUnfinishedTasks() {
        return ResponseFactory.ok(this.dtoConverter.toTaskInfos(this.engine.getAllIncompleteTasksForCurrentUser())).build();
    }

    @Override
    public Response getStepsForTask(String taskId) {
        Task task = this.engine.getTask(taskId);
        Steps steps = this.dtoConverter.toDto(task);
        steps.setTaskId(taskId);
        return ResponseFactory.ok(steps).build();
    }
}

