/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.reflect;

import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyHolder;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemPropertyDescriptor
implements Serializable,
ConfigurationItemPropertyHolder {
    private ConfigurationItemDescriptor owningConfigurationItemDescriptor;
    private ConfigurationItemPropertyDescriptor owningPropertyDescriptor;
    private String name;
    private ConfigurationItemPropertyType type;
    private boolean asContainment;
    private String[] enumValues;
    private String collectionMemberClassname;
    private String propertyClassname;
    private ConfigurationItemPropertyDescriptor[] listObjectPropertyDescriptors;
    private String label;
    private String description;
    private boolean required;
    private boolean editable;
    private boolean password;
    private boolean identifying;
    private boolean discoveryParam;
    private boolean discoveryRequired;
    private String category;
    private String defaultValue;
    private ConfigurationItemProperty.Size size;
    private transient Field propertyField;
    private transient Class<?> propertyClass;
    private transient Class<?> collectionMemberClass;
    private static Logger logger = Logger.getLogger(ConfigurationItemPropertyDescriptor.class);

    public ConfigurationItemPropertyDescriptor() {
    }

    public ConfigurationItemPropertyDescriptor(ConfigurationItemDescriptor owningCIDescriptor, ConfigurationItemPropertyDescriptor owningPropertyDescriptor, Field field, String defaultValue, boolean isTopLevelClass) {
        this.owningConfigurationItemDescriptor = owningCIDescriptor;
        this.owningPropertyDescriptor = owningPropertyDescriptor;
        this.setPropertyField(field);
        ConfigurationItemProperty propertyAnnotation = field.getAnnotation(ConfigurationItemProperty.class);
        this.initNames(propertyAnnotation);
        this.initType(propertyAnnotation, isTopLevelClass);
        this.initValidation(propertyAnnotation, defaultValue);
        this.initCapabilities(propertyAnnotation);
    }

    public static ConfigurationItemPropertyDescriptor[] getConfigurationItemPropertyDescriptorsForListObject(ConfigurationItemDescriptor owningCIDescriptor, ConfigurationItemPropertyDescriptor owningPropertyDescriptor, Class<?> listObjectClass) {
        return ConfigurationItemPropertyDescriptor.getConfigurationItemPropertyDescriptors(owningCIDescriptor, owningPropertyDescriptor, listObjectClass, null, null, false);
    }

    public static ConfigurationItemPropertyDescriptor[] getConfigurationItemPropertyDescriptorsForTopLevelClass(ConfigurationItemDescriptor owningCIDescriptor, Class<?> typeClass, Map<String, String> configuredDefaults, String defaultValueKeyPrefix) {
        return ConfigurationItemPropertyDescriptor.getConfigurationItemPropertyDescriptors(owningCIDescriptor, null, typeClass, configuredDefaults, defaultValueKeyPrefix, true);
    }

    private static ConfigurationItemPropertyDescriptor[] getConfigurationItemPropertyDescriptors(ConfigurationItemDescriptor owningCIDescriptor, ConfigurationItemPropertyDescriptor owningPropertyDescriptor, Class<?> typeClass, Map<String, String> configuredDefaults, String defaultValueKeyPrefix, boolean isTopLevelClass) {
        ArrayList<ConfigurationItemPropertyDescriptor> propertyDescriptorList = new ArrayList<ConfigurationItemPropertyDescriptor>();
        for (Field field : ConfigurationItemPropertyDescriptor.getAllAnnotatedProperties(typeClass)) {
            String defaultValue;
            String propertyName = field.getName();
            if (configuredDefaults != null && defaultValueKeyPrefix != null) {
                String defaultValueKey = defaultValueKeyPrefix + propertyName.toLowerCase();
                defaultValue = configuredDefaults.get(defaultValueKey);
            } else {
                defaultValue = null;
            }
            propertyDescriptorList.add(new ConfigurationItemPropertyDescriptor(owningCIDescriptor, owningPropertyDescriptor, field, defaultValue, isTopLevelClass));
        }
        return propertyDescriptorList.toArray(new ConfigurationItemPropertyDescriptor[propertyDescriptorList.size()]);
    }

    private static List<Field> getAllAnnotatedProperties(Class<?> ciClass) {
        return ConfigurationItemPropertyDescriptor.getAllAnnotatedProperties(ciClass, ConfigurationItemProperty.class);
    }

    private void initNames(ConfigurationItemProperty fieldAnnotation) {
        this.name = this.propertyField.getName();
        this.label = fieldAnnotation.label();
        if (StringUtils.isBlank(this.label)) {
            this.label = StringUtils.capitalize(StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase(this.name), " "));
        }
        this.description = fieldAnnotation.description();
        if (StringUtils.isBlank(this.description)) {
            this.description = this.label;
        }
    }

    private void initType(ConfigurationItemProperty fieldAnnotation, boolean isTopLevelClass) {
        this.propertyClass = this.propertyField.getType();
        this.propertyClassname = this.propertyClass.getName();
        if (this.propertyClass.equals(Boolean.TYPE)) {
            this.initBooleanType();
        } else if (this.propertyClass.equals(Integer.TYPE)) {
            this.initIntegerType();
        } else if (this.propertyClass.equals(String.class)) {
            this.initStringType();
        } else if (this.propertyClass.isEnum()) {
            this.initEnumType(this.propertyClass);
        } else if (this.propertyClass.equals(List.class)) {
            this.initListType(this.propertyField, isTopLevelClass);
        } else if (this.propertyClass.equals(Set.class)) {
            this.initSetType(fieldAnnotation);
        } else if (Serializable.class.isAssignableFrom(this.propertyClass)) {
            this.initCIType(fieldAnnotation);
        } else {
            throw new IllegalArgumentException("Property " + this.propertyField.getDeclaringClass().getName() + "." + this.propertyField.getName() + " is of an unsupported type");
        }
    }

    private void initUnsupportedCiType() {
        this.type = ConfigurationItemPropertyType.UNSUPPORTED;
    }

    private void initBooleanType() {
        this.type = ConfigurationItemPropertyType.BOOLEAN;
    }

    private void initIntegerType() {
        this.type = ConfigurationItemPropertyType.INTEGER;
    }

    private void initStringType() {
        this.type = ConfigurationItemPropertyType.STRING;
    }

    private void initEnumType(Class<?> fieldType) {
        this.type = ConfigurationItemPropertyType.ENUM;
        this.getEnumValues(fieldType);
    }

    private void getEnumValues(Class<?> fieldType) {
        ArrayList<String> enumVals = new ArrayList<String>();
        for (Object each : fieldType.getEnumConstants()) {
            enumVals.add(each.toString());
        }
        this.enumValues = enumVals.toArray(new String[enumVals.size()]);
    }

    private void initListType(Field f, boolean isTopLevelClass) {
        if (!isTopLevelClass) {
            throw new IllegalArgumentException("Property " + this.propertyField.getDeclaringClass().getName() + "." + this.propertyField.getName() + " is a list of objects in a list of objects");
        }
        this.type = ConfigurationItemPropertyType.LIST_OF_OBJECTS;
        this.collectionMemberClass = this.getListObjectClass(f);
        this.collectionMemberClassname = this.collectionMemberClass.getName();
        this.listObjectPropertyDescriptors = ConfigurationItemPropertyDescriptor.getConfigurationItemPropertyDescriptorsForListObject(this.owningConfigurationItemDescriptor, this, this.collectionMemberClass);
        if (this.listObjectPropertyDescriptors.length == 0) {
            throw new IllegalArgumentException("The list object " + this.collectionMemberClassname + " of " + f.getDeclaringClass().getName() + "." + f.getName() + " does not contain any @" + ConfigurationItemProperty.class.getSimpleName() + " annotations");
        }
    }

    private void initSetType(ConfigurationItemProperty fieldAnnotation) {
        Type genericType = this.propertyField.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                this.collectionMemberClass = (Class)t;
                this.collectionMemberClassname = this.collectionMemberClass.getName();
            }
            if (String.class.isAssignableFrom(this.collectionMemberClass)) {
                this.initSetOfStringsType();
            } else if (Serializable.class.isAssignableFrom(this.collectionMemberClass)) {
                this.initSetOfCIsType(fieldAnnotation);
            } else {
                logger.error("The property (Set) " + this.propertyField.getName() + " is UNSUPPORTED");
                this.initUnsupportedCiType();
            }
        }
    }

    private void initSetOfStringsType() {
        this.type = ConfigurationItemPropertyType.SET_OF_STRINGS;
    }

    private void initSetOfCIsType(ConfigurationItemProperty fieldAnnotation) {
        this.type = ConfigurationItemPropertyType.SET_OF_CIS;
        this.asContainment = fieldAnnotation.asContainment();
    }

    private void initCIType(ConfigurationItemProperty fieldAnnotation) {
        this.type = ConfigurationItemPropertyType.CI;
        this.asContainment = fieldAnnotation.asContainment();
    }

    private Class<?> getListObjectClass(Field f) {
        ParameterizedType listType = (ParameterizedType)f.getGenericType();
        Type[] listTypeArguments = listType.getActualTypeArguments();
        if (listTypeArguments.length != 1) {
            throw new IllegalArgumentException(f.getDeclaringClass().getName() + "." + f.getName() + "is of type java.util.List but does not have exactly 1 type parameter");
        }
        if (!(listTypeArguments[0] instanceof Class)) {
            throw new IllegalArgumentException(f.getDeclaringClass().getName() + "." + f.getName() + "is of type java.util.List but the first type parameter is not a concrete class");
        }
        return (Class)listTypeArguments[0];
    }

    private void initValidation(ConfigurationItemProperty fieldAnnotation, String defaultValue) {
        this.required = fieldAnnotation.required();
        this.defaultValue = defaultValue;
    }

    private void initCapabilities(ConfigurationItemProperty fieldAnnotation) {
        this.password = fieldAnnotation.password();
        this.editable = fieldAnnotation.editable();
        this.identifying = fieldAnnotation.identifying();
        this.discoveryParam = fieldAnnotation.discoveryParam();
        this.discoveryRequired = fieldAnnotation.discoveryRequired();
        this.category = fieldAnnotation.category();
        this.size = fieldAnnotation.size();
        if (this.size == ConfigurationItemProperty.Size.DEFAULT) {
            this.size = this.type == ConfigurationItemPropertyType.BOOLEAN || this.type == ConfigurationItemPropertyType.INTEGER ? ConfigurationItemProperty.Size.SMALL : ConfigurationItemProperty.Size.MEDIUM;
        }
    }

    public Object getPropertyValueFromConfigurationItem(Object configurationItem) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        try {
            return this.getPropertyField().get(configurationItem);
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Cannot read property " + this.getName() + " from configuration item of type " + this.getOwningConfigurationItemDescriptor().getType(), exc);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("Cannot read property " + this.getName() + " from configuration item of type " + this.getOwningConfigurationItemDescriptor().getType(), exc);
        }
    }

    public void setPropertyValueInConfigurationItem(Object configurationItem, Object value) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        try {
            this.getPropertyField().set(configurationItem, value);
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException("Cannot write property " + this.getName() + " from configuration item of type " + this.getOwningConfigurationItemDescriptor().getType(), exc);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("Cannot write property " + this.getName() + " from configuration item of type " + this.getOwningConfigurationItemDescriptor().getType(), exc);
        }
    }

    public ConfigurationItemDescriptor getOwningConfigurationItemDescriptor() {
        return this.owningConfigurationItemDescriptor;
    }

    public void setOwningConfigurationItemDescriptor(ConfigurationItemDescriptor configurationItemDescriptor) {
        this.owningConfigurationItemDescriptor = configurationItemDescriptor;
    }

    public ConfigurationItemPropertyDescriptor getOwningPropertyDescriptor() {
        return this.owningPropertyDescriptor;
    }

    public void setOwningPropertyDescriptor(ConfigurationItemPropertyDescriptor owningPropertyDescriptor) {
        this.owningPropertyDescriptor = owningPropertyDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field getPropertyField() {
        if (this.propertyField == null) {
            try {
                Field field = this.owningPropertyDescriptor != null ? ConfigurationItemPropertyDescriptor.getDeclaredFieldInClassAndSuperClasses(this.owningPropertyDescriptor.getCollectionMemberClass(), this.name) : ConfigurationItemPropertyDescriptor.getDeclaredFieldInClassAndSuperClasses(this.owningConfigurationItemDescriptor.getTypeClass(), this.name);
                this.setPropertyField(field);
            }
            catch (NoSuchFieldException exc) {
                throw new RuntimeException("Cannot find field " + this.name + " in " + this.owningConfigurationItemDescriptor.getTypeClass(), exc);
            }
        }
        return this.propertyField;
    }

    private void setPropertyField(Field propertyField) {
        this.propertyField = propertyField;
        this.propertyField.setAccessible(true);
    }

    public ConfigurationItemPropertyType getType() {
        return this.type;
    }

    public void setType(ConfigurationItemPropertyType type) {
        this.type = type;
    }

    public String getPropertyClassname() {
        return this.propertyClassname;
    }

    public void setPropertyClassname(String propertyClassname) {
        this.propertyClassname = propertyClassname;
    }

    public Class<?> getPropertyClass() {
        if (this.propertyClass == null) {
            if (this.propertyClassname == null) {
                return null;
            }
            try {
                this.propertyClass = this.propertyClassname.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (this.propertyClassname.equals(Integer.TYPE.getName()) ? Integer.TYPE : Class.forName(this.propertyClassname));
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Unable to get class for name " + this.propertyClassname, exc);
            }
        }
        return this.propertyClass;
    }

    public boolean asContainment() {
        return this.asContainment;
    }

    public void setAsContainment(boolean asContainment) {
        this.asContainment = asContainment;
    }

    public String[] getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(String[] enumValues) {
        this.enumValues = enumValues;
    }

    public String getCollectionMemberClassname() {
        return this.collectionMemberClassname;
    }

    public void setCollectionMemberClassname(String collectionMemberClassname) {
        this.collectionMemberClassname = collectionMemberClassname;
    }

    public Class<?> getCollectionMemberClass() {
        if (this.collectionMemberClass == null) {
            if (this.collectionMemberClassname == null) {
                return null;
            }
            try {
                this.collectionMemberClass = Class.forName(this.collectionMemberClassname);
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Unable to get class for name " + this.collectionMemberClassname, exc);
            }
        }
        return this.collectionMemberClass;
    }

    public ConfigurationItemPropertyDescriptor[] getListObjectPropertyDescriptors() {
        return this.listObjectPropertyDescriptors;
    }

    @Override
    public ConfigurationItemPropertyDescriptor[] getPropertyDescriptors() {
        return this.getListObjectPropertyDescriptors();
    }

    @Override
    public ConfigurationItemPropertyDescriptor getPropertyDescriptor(String propertyName) {
        for (ConfigurationItemPropertyDescriptor each : this.getPropertyDescriptors()) {
            if (!each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public void setListObjectPropertyDescriptors(ConfigurationItemPropertyDescriptor[] listObjectPropertyDescriptors) {
        this.listObjectPropertyDescriptors = listObjectPropertyDescriptors;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public void setIdentifying(boolean identifying) {
        this.identifying = identifying;
    }

    public boolean isDiscoveryParam() {
        return this.discoveryParam;
    }

    public void setDiscoveryParam(boolean discoveryParam) {
        this.discoveryParam = discoveryParam;
    }

    public boolean isDiscoveryRequired() {
        return this.discoveryRequired;
    }

    public void setDiscoveryRequired(boolean discoveryRequired) {
        this.discoveryRequired = discoveryRequired;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ConfigurationItemProperty.Size getSize() {
        return this.size;
    }

    public void setSize(ConfigurationItemProperty.Size size) {
        this.size = size;
    }

    public String toString() {
        return "ConfigurationItemPropertyDescriptor of " + this.getOwningConfigurationItemDescriptor().getType() + "." + this.getName();
    }

    static Field getDeclaredFieldInClassAndSuperClasses(Class<? extends Object> theClass, String name) throws NoSuchFieldException {
        try {
            return theClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            Class<? extends Object> superClass = theClass.getSuperclass();
            if (!Object.class.getName().equals(superClass.getName())) {
                return ConfigurationItemPropertyDescriptor.getDeclaredFieldInClassAndSuperClasses(superClass, name);
            }
            throw new NoSuchFieldException("Cannot find field " + name + " in " + theClass + " giving up.");
        }
    }

    static Field getSingleAnnotatedProperty(Class<?> ciClass, Class<? extends Annotation> annotationType, String messageIfMoreThanOne) {
        List<Field> allAnnotatedProperties = ConfigurationItemPropertyDescriptor.getAllAnnotatedProperties(ciClass, annotationType);
        if (allAnnotatedProperties.size() == 1) {
            return allAnnotatedProperties.get(0);
        }
        if (allAnnotatedProperties.size() > 1) {
            throw new IllegalArgumentException(messageIfMoreThanOne);
        }
        return null;
    }

    static List<Field> getAllAnnotatedProperties(Class<?> ciClass, Class<? extends Annotation> annotationType) {
        Field[] fields;
        ArrayList<Field> annotatedProperties = new ArrayList<Field>();
        Class<?> aClass = ciClass.getSuperclass();
        if (aClass == null) {
            return annotatedProperties;
        }
        if (!Object.class.getName().equals(aClass.getName())) {
            annotatedProperties.addAll(ConfigurationItemPropertyDescriptor.getAllAnnotatedProperties(ciClass.getSuperclass(), annotationType));
        }
        for (Field field : fields = ciClass.getDeclaredFields()) {
            Annotation configurationItemProperty = field.getAnnotation(annotationType);
            if (configurationItemProperty == null) continue;
            annotatedProperties.add(field);
        }
        return annotatedProperties;
    }
}

