/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.translation.DiscoveryChangePlan;
import com.xebialabs.deployit.translation.DiscoveryIdGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryService {
    @Autowired
    private PojoConverter pojoConverter;
    @Autowired
    private DiscoveryIdGenerator labelGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationItemEntity fetchConfiguration(ConfigurationItemEntity middlewareEntity) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            Discoverable<Serializable> discoverable = this.getDiscoverable(middlewareEntity, pojoConverterContext);
            DiscoveryChangePlan changePlan = new DiscoveryChangePlan();
            HashMap<String, Object> info = Maps.newHashMap();
            Serializable discoveredObject = discoverable.discover(info, changePlan);
            ConfigurationItemEntity configurationItemEntity = pojoConverterContext.toEntity(discoveredObject);
            return configurationItemEntity;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItemEntity> fetchConfigurationWithChildren(ConfigurationItemEntity middleware) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            List<ConfigurationItemEntity> discoveredEntities;
            HashMap<String, Object> info = Maps.newHashMap();
            DiscoveryChangePlan changePlan = new DiscoveryChangePlan();
            Discoverable<Serializable> discoverable = this.getDiscoverable(middleware, pojoConverterContext);
            Serializable discoveredObject = discoverable.discover(info, changePlan);
            discoverable.discoverChildrenInfo(info, changePlan);
            ArrayList<Serializable> discoveredItems = Lists.newArrayList();
            discoveredItems.add(discoveredObject);
            ArrayList<String> discovertedItemKeyList = Lists.newArrayList(info.keySet());
            Collections.sort(discovertedItemKeyList);
            for (String eachKey : discovertedItemKeyList) {
                Object possibleDiscoveredObjects = info.get(eachKey);
                if (!(possibleDiscoveredObjects instanceof Collection)) continue;
                for (Object eachPossibleDiscoveredObject : (Collection)possibleDiscoveredObjects) {
                    if (!eachPossibleDiscoveredObject.getClass().isAnnotationPresent(ConfigurationItem.class)) continue;
                    discoveredItems.add((Serializable)eachPossibleDiscoveredObject);
                }
            }
            this.labelGenerator.generateCorrectIds(discoveredItems);
            List<ConfigurationItemEntity> list = discoveredEntities = pojoConverterContext.toEntity(discoveredItems);
            return list;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    private Discoverable<Serializable> getDiscoverable(ConfigurationItemEntity middlewareEntity, PojoConverter.Context pojoConverterContext) {
        Serializable ci = (Serializable)pojoConverterContext.toPojo(middlewareEntity);
        Checks.checkArgument(ci instanceof Discoverable, "The configuration item [%s] is not discoverable.", middlewareEntity.getId());
        return (Discoverable)((Object)ci);
    }
}

