/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.FlattenedEntity;
import com.xebialabs.deployit.repository.Flattener;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Validator {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Flattener flattener;

    public Validations validate(RepositoryObjectEntity ci, RepositoryObjectEntity ... cisInContext) {
        Validations validations = new Validations();
        if (!validations.checkArchetypes(ci)) {
            return validations;
        }
        FlattenedEntity flattened = this.flattener.flatten(ci);
        String type = flattened.getConfigurationItemTypeName();
        ConfigurationItemDescriptor descriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(type);
        for (ConfigurationItemPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (flattened.isArchetype() || !propertyDescriptor.isRequired() || propertyDescriptor.asContainment()) continue;
            validations.checkRequired(flattened, propertyDescriptor);
        }
        for (String key : flattened.getValues().keySet()) {
            if (this.isPlaceholderField(key, descriptor) || !validations.checkFieldExists(flattened, descriptor, key)) continue;
            ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(key);
            Object value = flattened.getValue(propertyDescriptor);
            validations.checkType(flattened, propertyDescriptor, value, this.repositoryService, cisInContext);
        }
        if (descriptor.getPlaceholdersName() != null) {
            Object placeholdersObject = flattened.getValue(descriptor.getPlaceholdersName());
            if (!validations.checkHasSource(flattened)) {
                return validations;
            }
            if (placeholdersObject == null || placeholdersObject instanceof Collection && ((Collection)placeholdersObject).isEmpty()) {
                String sourceId = (String)flattened.getValue("source");
                Object source = this.repositoryService.read(sourceId);
                Object placeholdersFromSource = ((RepositoryObjectEntity)source).getValue("placeholders");
                if (placeholdersFromSource != null && !((Collection)placeholdersFromSource).isEmpty()) {
                    validations.add(new ValidationMessage((RepositoryObjectEntity)flattened, descriptor.getPlaceholdersName(), "Missing all placeholders from source %s (%s)", sourceId, placeholdersFromSource));
                }
            } else if (validations.checkPlaceholdersOfCorrectType(flattened, descriptor, placeholdersObject)) {
                validations.checkPlaceholdersAllFilled(flattened, descriptor, placeholdersObject);
                validations.checkPlaceholdersAllPresent(flattened, descriptor, placeholdersObject, this.repositoryService);
            }
        }
        return validations;
    }

    private boolean isPlaceholderField(String key, ConfigurationItemDescriptor descriptor) {
        return key.equals(descriptor.getPlaceholdersName()) || key.equals(descriptor.getPlaceholderFormatName());
    }

    public static class Validations
    extends ArrayList<ValidationMessage> {
        private void checkRequired(RepositoryObjectEntity ci, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            Object value = ci.getValue(propertyDescriptor);
            if (value == null || StringUtils.isBlank(value.toString())) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s is required", propertyDescriptor.getName()));
            }
        }

        public boolean hasMessages() {
            return !this.isEmpty();
        }

        private void checkInteger(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            if (value != null) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException nfe) {
                    this.add(new ValidationMessage(ci, propertyDescriptor, "Could not convert %s with value [%s] into an int", propertyDescriptor.getName(), value));
                }
            }
        }

        private void checkBoolean(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            if (value != null) {
                if ("true".equalsIgnoreCase(value.toString()) || "false".equalsIgnoreCase(value.toString())) {
                    return;
                }
                this.add(new ValidationMessage(ci, propertyDescriptor, "Could not convert %s with value [%s] into a boolean", propertyDescriptor.getName(), value));
            }
        }

        private void checkEnum(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            if (value != null) {
                for (String enumValue : propertyDescriptor.getEnumValues()) {
                    if (!enumValue.equals(value)) continue;
                    return;
                }
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value [%s] does not contain correct enum value", propertyDescriptor.getName(), value));
            }
        }

        private boolean checkFieldExists(RepositoryObjectEntity ci, ConfigurationItemDescriptor descriptor, String key) {
            ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(key);
            if (propertyDescriptor == null || !propertyDescriptor.getName().equals(key)) {
                this.add(new ValidationMessage(ci, key, "Property %s does not exist on configuration item", key));
                return false;
            }
            return true;
        }

        private void checkCi(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor, RepositoryService repositoryService, RepositoryObjectEntity[] cisInContext) {
            if (value == null || propertyDescriptor.asContainment()) {
                return;
            }
            if (!this.ciExists(value.toString(), repositoryService, cisInContext)) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value [%s] does not point to an existing configuration item", propertyDescriptor.getName(), value));
            }
        }

        private boolean ciExists(String ciId, RepositoryService repositoryService, RepositoryObjectEntity[] cisInContext) {
            return repositoryService.checkNodeExists(ciId) || this.inCisContext(ciId, cisInContext);
        }

        private boolean inCisContext(String ciId, RepositoryObjectEntity[] cisInContext) {
            for (RepositoryObjectEntity entity : cisInContext) {
                if (!entity.getId().equals(ciId)) continue;
                return true;
            }
            return false;
        }

        private void checkSetOfStrings(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor) {
            if (value == null) {
                return;
            }
            boolean valid = true;
            if (!(value instanceof Collection)) {
                valid = false;
            } else {
                for (Object o : (Collection)value) {
                    valid = valid && o instanceof String;
                }
            }
            if (!valid) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value %s[%s] does not contain a set of strings", propertyDescriptor.getName(), value.getClass().getSimpleName(), value));
            }
        }

        private void checkSetOfCis(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor, RepositoryService repositoryService, RepositoryObjectEntity[] cisInContext) {
            if (value == null || propertyDescriptor.asContainment()) {
                return;
            }
            boolean valid = true;
            if (!(value instanceof Collection)) {
                valid = false;
            } else {
                for (Object o : (Collection)value) {
                    valid = valid && o instanceof String && this.ciExists((String)o, repositoryService, cisInContext);
                }
            }
            if (!valid) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value %s[%s] does not contain a set of configuration items", propertyDescriptor.getName(), value.getClass().getSimpleName(), value));
            }
        }

        private void checkListOfObjects(RepositoryObjectEntity ci, Object value, ConfigurationItemPropertyDescriptor propertyDescriptor, RepositoryService repositoryService, RepositoryObjectEntity[] cisInContext) {
            if (value == null) {
                return;
            }
            boolean valid = true;
            if (!(value instanceof Collection)) {
                valid = false;
            } else {
                ConfigurationItemPropertyDescriptor[] listObjectDescriptors = propertyDescriptor.getListObjectPropertyDescriptors();
                for (Object o : (Collection)value) {
                    if (!(valid = valid && o instanceof Map)) continue;
                    Map map = (Map)o;
                    for (ConfigurationItemPropertyDescriptor lod : listObjectDescriptors) {
                        Object objValue = map.get(lod.getName());
                        Validations v = new Validations();
                        v.checkType(ci, lod, objValue, repositoryService, cisInContext);
                        valid = valid && !v.hasMessages();
                        this.addAll(v);
                    }
                    for (String key : map.keySet()) {
                        boolean found = false;
                        for (ConfigurationItemPropertyDescriptor descriptor : listObjectDescriptors) {
                            if (!descriptor.getName().equals(key)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s does not exist on the list of objects property %s", key, propertyDescriptor.getName()));
                        valid = false;
                    }
                }
            }
            if (!valid) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value [%s] does not contain a valid list of objects", propertyDescriptor.getName(), value));
            }
        }

        private void checkType(RepositoryObjectEntity ci, ConfigurationItemPropertyDescriptor propertyDescriptor, Object value, RepositoryService repositoryService, RepositoryObjectEntity[] cisInContext) {
            switch (propertyDescriptor.getType()) {
                case BOOLEAN: {
                    this.checkBoolean(ci, value, propertyDescriptor);
                    break;
                }
                case INTEGER: {
                    this.checkInteger(ci, value, propertyDescriptor);
                    break;
                }
                case STRING: {
                    break;
                }
                case ENUM: {
                    this.checkEnum(ci, value, propertyDescriptor);
                    break;
                }
                case LIST_OF_OBJECTS: {
                    this.checkListOfObjects(ci, value, propertyDescriptor, repositoryService, cisInContext);
                    break;
                }
                case SET_OF_STRINGS: {
                    this.checkSetOfStrings(ci, value, propertyDescriptor);
                    break;
                }
                case CI: {
                    this.checkCi(ci, value, propertyDescriptor, repositoryService, cisInContext);
                    break;
                }
                case SET_OF_CIS: {
                    this.checkSetOfCis(ci, value, propertyDescriptor, repositoryService, cisInContext);
                    break;
                }
            }
        }

        private void checkPlaceholdersAllFilled(FlattenedEntity flattened, ConfigurationItemDescriptor descriptor, Object placeholdersObject) {
            List placeholders = (List)placeholdersObject;
            for (Map placeholder : placeholders) {
                if (!StringUtils.isBlank((String)placeholder.get("value"))) continue;
                this.add(new ValidationMessage((RepositoryObjectEntity)flattened, descriptor.getPlaceholdersName(), "Placeholder [%s] is not mapped to any value", placeholder.get("key")));
            }
        }

        public void checkPlaceholdersAllPresent(FlattenedEntity flattened, ConfigurationItemDescriptor descriptor, Object placeholdersObject, RepositoryService repositoryService) {
            List placeholders = (List)placeholdersObject;
            String sourceId = (String)flattened.getValue("source");
            Object source = repositoryService.read(sourceId);
            Set placeholderSet = (Set)((RepositoryObjectEntity)source).getValue("placeholders");
            if (placeholderSet == null) {
                return;
            }
            Collection<String> transformed = Collections2.transform(placeholders, new Function<Map<String, String>, String>(){

                @Override
                public String apply(Map<String, String> from) {
                    return from.get("key");
                }
            });
            for (Object placeholder : placeholderSet) {
                if (transformed.contains(placeholder)) continue;
                this.add(new ValidationMessage((RepositoryObjectEntity)flattened, descriptor.getPlaceholdersName(), "Placeholders is missing key [%s]", placeholder));
            }
            for (Object placeholder : placeholders) {
                if (placeholderSet.contains(placeholder.get("key"))) continue;
                this.add(new ValidationMessage((RepositoryObjectEntity)flattened, descriptor.getPlaceholdersName(), "Placeholders has key [%s] which is not present in the source", placeholder));
            }
        }

        private boolean checkPlaceholdersOfCorrectType(FlattenedEntity flattened, ConfigurationItemDescriptor descriptor, Object placeholdersObject) {
            if (!(placeholdersObject instanceof Collection)) {
                this.add(new ValidationMessage((RepositoryObjectEntity)flattened, descriptor.getPlaceholdersName(), "Placeholders in field [%s] are not of correct type [%s]", descriptor.getPlaceholdersName(), placeholdersObject.getClass().getName()));
                return false;
            }
            if (Collections2.filter((Collection)placeholdersObject, new Predicate<Object>(){

                @Override
                public boolean apply(Object input) {
                    return !(input instanceof Map);
                }
            }).size() > 0) {
                this.add(new ValidationMessage((RepositoryObjectEntity)flattened, descriptor.getPlaceholdersName(), "Placeholders in field [%s] are not of correct type.", descriptor.getPlaceholdersName()));
                return false;
            }
            return true;
        }

        public boolean checkArchetypes(RepositoryObjectEntity ci) {
            String archetypeType;
            if (ci.getConfigurationItemArchetype() != null && !(archetypeType = ci.getConfigurationItemArchetype().getConfigurationItemTypeName()).equals(ci.getConfigurationItemTypeName())) {
                this.add(new ValidationMessage(ci, "configurationItemArchetype", "The archetype is not of type %s, but of %s", ci.getConfigurationItemTypeName(), archetypeType));
                return false;
            }
            return true;
        }

        public boolean checkHasSource(FlattenedEntity flattened) {
            return flattened.getValue("source") != null;
        }
    }
}

