/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.StepExecutionContextListener;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.ci.artifact.SqlFolder;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingHostFileInputTransformer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseStep
implements Step {
    protected final Database database;
    protected final SqlFolder source;
    private final Map<String, String> properties;
    private final PlaceholderFormat placeholderFormat;

    public AbstractDatabaseStep(SqlFolder source, Database database, Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        this.source = source;
        this.database = database;
        this.properties = properties;
        this.placeholderFormat = placeholderFormat;
    }

    protected HostSession getHostSession(StepExecutionContext ctx) {
        Host host = this.database.getHost();
        String key = "HSC_" + host.getLabel();
        AttributeValue<HostSession> hsc = (AttributeValue<HostSession>)ctx.getAttribute(key);
        if (hsc == null) {
            hsc = new AttributeValue<HostSession>(host.getHostSession(), new ContextDestroyedHandler<HostSession>(){

                @Override
                public void close(HostSession hostSession) {
                    hostSession.close();
                }
            });
            ctx.setAttribute(key, hsc);
        }
        return (HostSession)hsc.get();
    }

    protected String getSqlRunnerPath(StepExecutionContext ctx) {
        String sqlRunnerPath = (String)ctx.getAttribute(this.database.getLabel());
        if (sqlRunnerPath == null) {
            GenerateSqlRunnerScriptStep runnerScriptStep = new GenerateSqlRunnerScriptStep();
            ctx.logOutput(runnerScriptStep.getDescription());
            runnerScriptStep.execute(ctx);
            sqlRunnerPath = (String)ctx.getAttribute(this.database.getLabel());
        }
        ctx.logOutput("SqlRunner file is " + sqlRunnerPath);
        return sqlRunnerPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HostFile getRemoteLocation(StepExecutionContext ctx) {
        String key = "RL" + this.source.getLabel();
        AttributeValue<HostFile> avRemote = (AttributeValue<HostFile>)ctx.getAttribute(key);
        if (avRemote == null) {
            HostSession sourceSession = Host.getLocalHost().getHostSession();
            try {
                HostFile sourceHostDir = sourceSession.getFile(this.source.getLocation());
                HostFile destinationDir = this.getHostSession(ctx).getTempFile(this.source.getLabel().replace(' ', '_'), ".sql");
                destinationDir.mkdirs();
                String description = "Copy " + this.source.getLocation() + " from " + Host.getLocalHost() + " to " + destinationDir + " on " + this.database.getHost();
                if (this.properties != null && !this.properties.isEmpty()) {
                    description = description + " while replacing property values using " + this.placeholderFormat + " placeholder format";
                }
                ctx.logOutput(description);
                HostFileUtils.copy(sourceHostDir, destinationDir, this.getTransformer());
                avRemote = new AttributeValue<HostFile>(destinationDir);
                ctx.setAttribute(key, avRemote);
            }
            finally {
                sourceSession.close();
            }
        }
        return (HostFile)avRemote.get();
    }

    private HostFileInputStreamTransformer getTransformer() {
        if (this.properties == null) {
            return null;
        }
        if (this.properties.isEmpty()) {
            return null;
        }
        return new LenientTemplateResolvingHostFileInputTransformer(this.properties, this.placeholderFormat);
    }

    class GenerateSqlRunnerScriptStep
    implements Step {
        protected OperatingSystemFamily osFamily;
        protected String suffix;
        protected String env;

        public GenerateSqlRunnerScriptStep() {
            this.osFamily = AbstractDatabaseStep.this.database.getHost().getOperatingSystemFamily();
            this.suffix = this.osFamily.getScriptExtension();
            this.env = this.osFamily == OperatingSystemFamily.UNIX ? "export" : "set";
        }

        public String getDescription() {
            return "Generate SqlRunner file remote command on " + AbstractDatabaseStep.this.database.getHost() + ".";
        }

        public boolean execute(StepExecutionContext ctx) {
            HostSession s = AbstractDatabaseStep.this.getHostSession(ctx);
            try {
                StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
                ctx.logOutput("Generate the sql runner file on " + AbstractDatabaseStep.this.database.getHost());
                HostFile sqlRunnerFile = s.getTempFile("sqlRunner-" + AbstractDatabaseStep.this.database.getLabel().replace(' ', '_'), this.suffix);
                sqlRunnerFile.getParentFile().mkdirs();
                String currentPassword = AbstractDatabaseStep.this.database.getPassword();
                AbstractDatabaseStep.this.database.setPassword("*********");
                ctx.logOutput(AbstractDatabaseStep.this.database.getCommand());
                AbstractDatabaseStep.this.database.setPassword(currentPassword);
                String command = AbstractDatabaseStep.this.database.getCommand();
                HostFileUtils.putStringToHostFile(command, sqlRunnerFile);
                if (this.osFamily.equals((Object)OperatingSystemFamily.UNIX)) {
                    s.execute((CommandExecutionCallbackHandler)handler, "chmod", "+x", sqlRunnerFile.getPath());
                }
                ctx.setAttribute(AbstractDatabaseStep.this.database.getLabel(), sqlRunnerFile.getPath());
                return true;
            }
            catch (RuntimeIOException exc) {
                throw new RuntimeIOException("Cannot generate bulk file remote command on " + AbstractDatabaseStep.this.database.getHost(), exc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeValue<T>
    implements StepExecutionContextListener {
        private final T value;
        private final ContextDestroyedHandler<T> handler;

        public AttributeValue(T value) {
            this(value, null);
        }

        public AttributeValue(T value, ContextDestroyedHandler<T> handler) {
            this.value = value;
            this.handler = handler;
        }

        public T get() {
            return this.value;
        }

        @Override
        public void contextDestroyed() {
            if (this.handler != null && this.value != null) {
                this.handler.close(this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ContextDestroyedHandler<T> {
        public void close(T var1);
    }
}

