/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.Task;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class UpgradeDeploymentTask
extends Task {
    private final Collection<ConfigurationItemEntity> mappingEntities;
    private final ConfigurationItemEntity newDeploymentEntity;

    public UpgradeDeploymentTask(Collection<ConfigurationItemEntity> mappingEntities, ConfigurationItemEntity newDeploymentEntity, List<Step> steps, RepositoryService repositoryService, PojoConverter pojoConverter, PojoConverter.Context ... pojoConverterContexts) {
        super(steps, repositoryService, pojoConverter, pojoConverterContexts);
        this.mappingEntities = mappingEntities;
        this.newDeploymentEntity = newDeploymentEntity;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                Object existingDeployment = UpgradeDeploymentTask.this.repositoryService.read(UpgradeDeploymentTask.this.newDeploymentEntity.getId());
                Set mappingIds = (Set)((RepositoryObjectEntity)existingDeployment).getValue("mappings");
                ((RepositoryObjectEntity)existingDeployment).addValue("mappings", Sets.newHashSet());
                UpgradeDeploymentTask.this.repositoryService.update(existingDeployment);
                for (Object each : mappingIds) {
                    UpgradeDeploymentTask.this.repositoryService.delete((String)each);
                }
                for (Object each : UpgradeDeploymentTask.this.mappingEntities) {
                    String mappingId = ((RepositoryObjectEntity)each).getId();
                    int i = 0;
                    while (true) {
                        if (i != 0) {
                            ((RepositoryObjectEntity)each).setId(mappingId + " (" + i + ")");
                        }
                        try {
                            UpgradeDeploymentTask.this.repositoryService.create(new ConfigurationItemEntity[]{each});
                        }
                        catch (ItemAlreadyExistsException exc) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                    Set newMappingIds = (Set)UpgradeDeploymentTask.this.newDeploymentEntity.getValue("mappings");
                    newMappingIds.remove(mappingId);
                    newMappingIds.add(((RepositoryObjectEntity)each).getId());
                }
                UpgradeDeploymentTask.this.newDeploymentEntity.setCreatingTaskId(UpgradeDeploymentTask.this.getId());
                UpgradeDeploymentTask.this.repositoryService.update(UpgradeDeploymentTask.this.newDeploymentEntity);
                return null;
            }
        });
    }

    @Override
    public boolean isDeploymentTask() {
        return true;
    }
}

