/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.generators.DigestRandom;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import de.schlichtherle.crypto.modes.SICSeekableBlockCipher;
import de.schlichtherle.io.util.LEDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

class Type0RaesOutputStream
extends RaesOutputStream {
    static final int ITERATION_COUNT = 2005;
    private int keyStrengthBits;
    private Mac mac;
    private Mac klac;
    private LEDataOutputStream dos;
    private long start;
    private boolean closed;
    static final /* synthetic */ boolean $assertionsDisabled;

    Type0RaesOutputStream(OutputStream out, Type0RaesParameters parameters) throws NullPointerException, IllegalArgumentException, RaesKeyException, IOException {
        super(out, null);
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameters == null) {
            throw new AssertionError();
        }
        char[] passwd = parameters.getCreatePasswd();
        if (passwd == null) {
            throw new RaesKeyException();
        }
        int keyStrength = parameters.getKeyStrength();
        if (keyStrength != 0 && keyStrength != 1 && keyStrength != 2) {
            throw new IllegalArgumentException("Illegal cipher key strength: " + keyStrength + "!");
        }
        SHA256Digest digest = new SHA256Digest();
        int keyStrengthBytes = 16 + keyStrength * 8;
        this.keyStrengthBits = keyStrengthBytes * 8;
        if (!$assertionsDisabled && digest.getDigestSize() < keyStrengthBytes) {
            throw new AssertionError();
        }
        byte[] salt = new byte[keyStrengthBytes];
        new DigestRandom(digest).nextBytes(salt);
        PKCS12ParametersGenerator paramGen = new PKCS12ParametersGenerator(digest);
        byte[] pass = PBEParametersGenerator.PKCS12PasswordToBytes(passwd);
        int i = passwd.length;
        while (--i >= 0) {
            passwd[i] = '\u0000';
        }
        paramGen.init(pass, salt, 2005);
        ParametersWithIV cipherParam = (ParametersWithIV)((PBEParametersGenerator)paramGen).generateDerivedParameters(this.keyStrengthBits, 128);
        CipherParameters macParam = ((PBEParametersGenerator)paramGen).generateDerivedMacParameters(this.keyStrengthBits);
        int i2 = pass.length;
        while (--i2 >= 0) {
            pass[i2] = 0;
        }
        BufferedBlockCipher cipher = new BufferedBlockCipher(new SICSeekableBlockCipher(new AESFastEngine()));
        cipher.init(true, cipherParam);
        this.mac = new HMac(new SHA256Digest());
        this.mac.init(macParam);
        this.klac = new HMac(digest);
        this.klac.init(macParam);
        byte[] cipherKey = ((KeyParameter)cipherParam.getParameters()).getKey();
        this.klac.update(cipherKey, 0, cipherKey.length);
        this.dos = new LEDataOutputStream(out);
        this.out = new MacOutputStream(this.dos, this.mac);
        this.dos.writeInt(1397047634);
        this.dos.writeByte(0);
        this.dos.writeByte(keyStrength);
        this.dos.writeShort(2005);
        this.dos.write(salt);
        this.start = this.dos.size();
        if (!$assertionsDisabled && this.start != (long)(8 + salt.length)) {
            throw new AssertionError();
        }
        this.cipher = cipher;
    }

    public int getKeySizeBits() {
        return this.keyStrengthBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.finish();
                long trailer = this.dos.size();
                if (!$assertionsDisabled && this.mac.getMacSize() != this.klac.getMacSize()) {
                    throw new AssertionError();
                }
                byte[] buf = new byte[this.mac.getMacSize()];
                long length = trailer - this.start;
                Type0RaesOutputStream.klac(this.klac, length, buf);
                this.dos.write(buf, 0, buf.length / 2);
                int bufLen = this.mac.doFinal(buf, 0);
                if (!$assertionsDisabled && bufLen != buf.length) {
                    throw new AssertionError();
                }
                this.dos.write(buf, 0, buf.length / 2);
                if (!$assertionsDisabled && this.dos.size() - trailer != (long)buf.length) {
                    throw new AssertionError();
                }
            }
            finally {
                super.close();
            }
        }
    }

    static {
        $assertionsDisabled = !Type0RaesOutputStream.class.desiredAssertionStatus();
    }
}

