/*
 * Decompiled with CFR 0.152.
 */
package javassist.util.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.util.proxy.FactoryHelper;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javassist.util.proxy.RuntimeSupport;
import javassist.util.proxy.SecurityActions;

public class ProxyFactory {
    private Class superClass = null;
    private Class[] interfaces = null;
    private MethodFilter methodFilter = null;
    private MethodHandler handler = null;
    private Class thisClass = null;
    public String writeDirectory = null;
    private static final Class OBJECT_TYPE = class$java$lang$Object == null ? (class$java$lang$Object = ProxyFactory.class$("java.lang.Object")) : class$java$lang$Object;
    private static final String HOLDER = "_methods_";
    private static final String HOLDER_TYPE = "[Ljava/lang/reflect/Method;";
    private static final String METHOD_FILTER_FIELD = "_method_filter";
    private static final String HANDLER = "handler";
    private static final String NULL_INTERCEPTOR_HOLDER = "javassist.util.proxy.RuntimeSupport";
    private static final String DEFAULT_INTERCEPTOR = "default_interceptor";
    private static final String HANDLER_TYPE = 'L' + (class$javassist$util$proxy$MethodHandler == null ? (class$javassist$util$proxy$MethodHandler = ProxyFactory.class$("javassist.util.proxy.MethodHandler")) : class$javassist$util$proxy$MethodHandler).getName().replace('.', '/') + ';';
    private static final String HANDLER_SETTER = "setHandler";
    private static final String HANDLER_SETTER_TYPE = "(" + HANDLER_TYPE + ")V";
    public static boolean useCache = true;
    private static WeakHashMap proxyCache = new WeakHashMap();
    public static ClassLoaderProvider classLoaderProvider = new ClassLoaderProvider(){

        public ClassLoader get(ProxyFactory pf) {
            return pf.getClassLoader0();
        }
    };
    private static int counter = 0;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javassist$util$proxy$MethodHandler;
    static /* synthetic */ Class class$javassist$util$proxy$ProxyObject;
    static /* synthetic */ Class class$javassist$util$proxy$RuntimeSupport;

    public void setSuperclass(Class clazz) {
        this.superClass = clazz;
    }

    public Class getSuperclass() {
        return this.superClass;
    }

    public void setInterfaces(Class[] ifs) {
        this.interfaces = ifs;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public void setFilter(MethodFilter mf) {
        this.methodFilter = mf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class createClass() {
        if (this.thisClass == null) {
            ClassLoader cl = this.getClassLoader();
            WeakHashMap weakHashMap = proxyCache;
            synchronized (weakHashMap) {
                if (useCache) {
                    this.createClass2(cl);
                } else {
                    this.createClass3(cl);
                }
            }
        }
        return this.thisClass;
    }

    private void createClass2(ClassLoader cl) {
        CacheKey key = new CacheKey(this.superClass, this.interfaces, this.methodFilter, this.handler);
        HashMap<CacheKey, CacheKey> cacheForTheLoader = (HashMap<CacheKey, CacheKey>)proxyCache.get(cl);
        if (cacheForTheLoader == null) {
            cacheForTheLoader = new HashMap<CacheKey, CacheKey>();
            proxyCache.put(cl, cacheForTheLoader);
            cacheForTheLoader.put(key, key);
        } else {
            CacheKey found = (CacheKey)cacheForTheLoader.get(key);
            if (found == null) {
                cacheForTheLoader.put(key, key);
            } else {
                key = found;
                Class c = this.isValidEntry(key);
                if (c != null) {
                    this.thisClass = c;
                    return;
                }
            }
        }
        Class c = this.isValidEntry(key);
        if (c == null) {
            this.createClass3(cl);
            key.proxyClass = new WeakReference<Class>(this.thisClass);
        } else {
            this.thisClass = c;
        }
    }

    private Class isValidEntry(CacheKey key) {
        Class c;
        WeakReference ref = key.proxyClass;
        if (ref != null && (c = (Class)ref.get()) != null) {
            return c;
        }
        return null;
    }

    private void createClass3(ClassLoader cl) {
        try {
            ClassFile cf = this.make();
            if (this.writeDirectory != null) {
                FactoryHelper.writeFile(cf, this.writeDirectory);
            }
            this.thisClass = FactoryHelper.toClass(cf, cl, this.getDomain());
            this.setField(DEFAULT_INTERCEPTOR, this.handler);
            this.setField(METHOD_FILTER_FIELD, this.methodFilter);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setField(String fieldName, Object value) {
        if (this.thisClass != null && value != null) {
            try {
                Field f = this.thisClass.getField(fieldName);
                SecurityActions.setAccessible(f, true);
                f.set(null, value);
                SecurityActions.setAccessible(f, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static MethodFilter getFilter(Class clazz) {
        return (MethodFilter)ProxyFactory.getField(clazz, METHOD_FILTER_FIELD);
    }

    static MethodHandler getHandler(Class clazz) {
        return (MethodHandler)ProxyFactory.getField(clazz, DEFAULT_INTERCEPTOR);
    }

    private static Object getField(Class clazz, String fieldName) {
        try {
            Field f = clazz.getField(fieldName);
            f.setAccessible(true);
            Object value = f.get(null);
            f.setAccessible(false);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassLoader getClassLoader() {
        return classLoaderProvider.get(this);
    }

    protected ClassLoader getClassLoader0() {
        ClassLoader loader = null;
        if (this.superClass != null && !this.superClass.getName().equals("java.lang.Object")) {
            loader = this.superClass.getClassLoader();
        } else if (this.interfaces != null && this.interfaces.length > 0) {
            loader = this.interfaces[0].getClassLoader();
        }
        if (loader == null && (loader = this.getClass().getClassLoader()) == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    protected ProtectionDomain getDomain() {
        Class clazz = this.superClass != null && !this.superClass.getName().equals("java.lang.Object") ? this.superClass : (this.interfaces != null && this.interfaces.length > 0 ? this.interfaces[0] : this.getClass());
        return clazz.getProtectionDomain();
    }

    public Object create(Class[] paramTypes, Object[] args, MethodHandler mh) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object obj = this.create(paramTypes, args);
        ((ProxyObject)obj).setHandler(mh);
        return obj;
    }

    public Object create(Class[] paramTypes, Object[] args) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class c = this.createClass();
        Constructor cons = c.getConstructor(paramTypes);
        return cons.newInstance(args);
    }

    public void setHandler(MethodHandler mi) {
        this.handler = mi;
        this.setField(DEFAULT_INTERCEPTOR, this.handler);
    }

    private static synchronized String makeProxyName(String classname) {
        return classname + "_$$_javassist_" + counter++;
    }

    private ClassFile make() throws CannotCompileException {
        String classname;
        String superName;
        if (this.interfaces == null) {
            this.interfaces = new Class[0];
        }
        if (this.superClass == null) {
            this.superClass = OBJECT_TYPE;
            superName = this.superClass.getName();
            classname = this.interfaces.length == 0 ? superName : this.interfaces[0].getName();
        } else {
            classname = superName = this.superClass.getName();
        }
        if (Modifier.isFinal(this.superClass.getModifiers())) {
            throw new CannotCompileException(superName + " is final");
        }
        if ((classname = ProxyFactory.makeProxyName(classname)).startsWith("java.")) {
            classname = "org.javassist.tmp." + classname;
        }
        ClassFile cf = new ClassFile(false, classname, superName);
        cf.setAccessFlags(1);
        ProxyFactory.setInterfaces(cf, this.interfaces);
        ConstPool pool = cf.getConstPool();
        FieldInfo finfo = new FieldInfo(pool, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        finfo.setAccessFlags(9);
        cf.addField(finfo);
        FieldInfo finfo2 = new FieldInfo(pool, HANDLER, HANDLER_TYPE);
        finfo2.setAccessFlags(2);
        cf.addField(finfo2);
        FieldInfo finfo3 = new FieldInfo(pool, METHOD_FILTER_FIELD, "Ljavassist/util/proxy/MethodFilter;");
        finfo3.setAccessFlags(9);
        cf.addField(finfo3);
        HashMap allMethods = ProxyFactory.getMethods(this.superClass, this.interfaces);
        int size = allMethods.size();
        this.makeConstructors(classname, cf, pool, classname);
        int s = this.overrideMethods(cf, pool, classname, allMethods);
        ProxyFactory.addMethodsHolder(cf, pool, classname, s);
        ProxyFactory.addSetter(classname, cf, pool);
        try {
            cf.addMethod(ProxyFactory.makeWriteReplace(pool));
        }
        catch (DuplicateMemberException e) {
            // empty catch block
        }
        this.thisClass = null;
        return cf;
    }

    private static void setInterfaces(ClassFile cf, Class[] interfaces) {
        String[] list;
        String setterIntf = (class$javassist$util$proxy$ProxyObject == null ? (class$javassist$util$proxy$ProxyObject = ProxyFactory.class$("javassist.util.proxy.ProxyObject")) : class$javassist$util$proxy$ProxyObject).getName();
        if (interfaces == null || interfaces.length == 0) {
            list = new String[]{setterIntf};
        } else {
            list = new String[interfaces.length + 1];
            for (int i = 0; i < interfaces.length; ++i) {
                list[i] = interfaces[i].getName();
            }
            list[interfaces.length] = setterIntf;
        }
        cf.setInterfaces(list);
    }

    private static void addMethodsHolder(ClassFile cf, ConstPool cp, String classname, int size) throws CannotCompileException {
        FieldInfo finfo = new FieldInfo(cp, HOLDER, HOLDER_TYPE);
        finfo.setAccessFlags(10);
        cf.addField(finfo);
        MethodInfo minfo = new MethodInfo(cp, "<clinit>", "()V");
        minfo.setAccessFlags(8);
        Bytecode code = new Bytecode(cp, 0, 0);
        code.addIconst(size * 2);
        code.addAnewarray("java.lang.reflect.Method");
        code.addPutstatic(classname, HOLDER, HOLDER_TYPE);
        code.addOpcode(177);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cf.addMethod(minfo);
    }

    private static void addSetter(String classname, ClassFile cf, ConstPool cp) throws CannotCompileException {
        MethodInfo minfo = new MethodInfo(cp, HANDLER_SETTER, HANDLER_SETTER_TYPE);
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 2, 2);
        code.addAload(0);
        code.addAload(1);
        code.addPutfield(classname, HANDLER, HANDLER_TYPE);
        code.addOpcode(177);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cf.addMethod(minfo);
    }

    private int overrideMethods(ClassFile cf, ConstPool cp, String className, HashMap allMethods) throws CannotCompileException {
        String prefix = ProxyFactory.makeUniqueName("_d", allMethods);
        Set entries = allMethods.entrySet();
        Iterator it = entries.iterator();
        int index = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Method meth = (Method)e.getValue();
            int mod = meth.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || !ProxyFactory.isVisible(mod, className, meth) || this.methodFilter != null && !this.methodFilter.isHandled(meth)) continue;
            this.override(className, meth, prefix, index++, ProxyFactory.keyToDesc(key), cf, cp);
        }
        return index;
    }

    private void override(String thisClassname, Method meth, String prefix, int index, String desc, ClassFile cf, ConstPool cp) throws CannotCompileException {
        Class<?> declClass = meth.getDeclaringClass();
        String delegatorName = prefix + index + meth.getName();
        if (Modifier.isAbstract(meth.getModifiers())) {
            delegatorName = null;
        } else {
            MethodInfo delegator = ProxyFactory.makeDelegator(meth, desc, cp, declClass, delegatorName);
            delegator.setAccessFlags(delegator.getAccessFlags() & 0xFFFFFFBF);
            cf.addMethod(delegator);
        }
        MethodInfo forwarder = ProxyFactory.makeForwarder(thisClassname, meth, desc, cp, declClass, delegatorName, index);
        cf.addMethod(forwarder);
    }

    private void makeConstructors(String thisClassName, ClassFile cf, ConstPool cp, String classname) throws CannotCompileException {
        Constructor[] cons = SecurityActions.getDeclaredConstructors(this.superClass);
        for (int i = 0; i < cons.length; ++i) {
            Constructor c = cons[i];
            int mod = c.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isPrivate(mod) || !ProxyFactory.isVisible(mod, classname, c)) continue;
            MethodInfo m = ProxyFactory.makeConstructor(thisClassName, c, cp, this.superClass);
            cf.addMethod(m);
        }
    }

    private static String makeUniqueName(String name, HashMap hash) {
        Set keys = hash.keySet();
        if (ProxyFactory.makeUniqueName0(name, keys.iterator())) {
            return name;
        }
        for (int i = 100; i < 999; ++i) {
            String s = name + i;
            if (!ProxyFactory.makeUniqueName0(s, keys.iterator())) continue;
            return s;
        }
        throw new RuntimeException("cannot make a unique method name");
    }

    private static boolean makeUniqueName0(String name, Iterator it) {
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(name)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVisible(int mod, String from, Member meth) {
        if ((mod & 2) != 0) {
            return false;
        }
        if ((mod & 5) != 0) {
            return true;
        }
        String p = ProxyFactory.getPackageName(from);
        String q = ProxyFactory.getPackageName(meth.getDeclaringClass().getName());
        if (p == null) {
            return q == null;
        }
        return p.equals(q);
    }

    private static String getPackageName(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return name.substring(0, i);
    }

    private static HashMap getMethods(Class superClass, Class[] interfaceTypes) {
        HashMap hash = new HashMap();
        for (int i = 0; i < interfaceTypes.length; ++i) {
            ProxyFactory.getMethods(hash, interfaceTypes[i]);
        }
        ProxyFactory.getMethods(hash, superClass);
        return hash;
    }

    private static void getMethods(HashMap hash, Class clazz) {
        Class<?>[] ifs = clazz.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            ProxyFactory.getMethods(hash, ifs[i]);
        }
        Class parent = clazz.getSuperclass();
        if (parent != null) {
            ProxyFactory.getMethods(hash, parent);
        }
        Method[] methods = SecurityActions.getDeclaredMethods(clazz);
        for (int i = 0; i < methods.length; ++i) {
            if (Modifier.isPrivate(methods[i].getModifiers())) continue;
            Method m = methods[i];
            String key = m.getName() + ':' + RuntimeSupport.makeDescriptor(m);
            hash.put(key, methods[i]);
        }
    }

    private static String keyToDesc(String key) {
        return key.substring(key.indexOf(58) + 1);
    }

    private static MethodInfo makeConstructor(String thisClassName, Constructor cons, ConstPool cp, Class superClass) {
        String desc = RuntimeSupport.makeDescriptor(cons.getParameterTypes(), Void.TYPE);
        MethodInfo minfo = new MethodInfo(cp, "<init>", desc);
        minfo.setAccessFlags(1);
        ProxyFactory.setThrows(minfo, cp, cons.getExceptionTypes());
        Bytecode code = new Bytecode(cp, 0, 0);
        code.addAload(0);
        code.addGetstatic(thisClassName, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        code.addPutfield(thisClassName, HANDLER, HANDLER_TYPE);
        code.addGetstatic(thisClassName, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        code.addOpcode(199);
        code.addIndex(10);
        code.addAload(0);
        code.addGetstatic(NULL_INTERCEPTOR_HOLDER, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        code.addPutfield(thisClassName, HANDLER, HANDLER_TYPE);
        int pc = code.currentPc();
        code.addAload(0);
        int s = ProxyFactory.addLoadParameters(code, cons.getParameterTypes(), 1);
        code.addInvokespecial(superClass.getName(), "<init>", desc);
        code.addOpcode(177);
        code.setMaxLocals(s + 1);
        CodeAttribute ca = code.toCodeAttribute();
        minfo.setCodeAttribute(ca);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.sameFrame(pc);
        ca.setAttribute(writer.toStackMapTable(cp));
        return minfo;
    }

    private static MethodInfo makeDelegator(Method meth, String desc, ConstPool cp, Class declClass, String delegatorName) {
        MethodInfo delegator = new MethodInfo(cp, delegatorName, desc);
        delegator.setAccessFlags(0x11 | meth.getModifiers() & 0xFFFFFAD9);
        ProxyFactory.setThrows(delegator, cp, meth);
        Bytecode code = new Bytecode(cp, 0, 0);
        code.addAload(0);
        int s = ProxyFactory.addLoadParameters(code, meth.getParameterTypes(), 1);
        code.addInvokespecial(declClass.getName(), meth.getName(), desc);
        ProxyFactory.addReturn(code, meth.getReturnType());
        code.setMaxLocals(++s);
        delegator.setCodeAttribute(code.toCodeAttribute());
        return delegator;
    }

    private static MethodInfo makeForwarder(String thisClassName, Method meth, String desc, ConstPool cp, Class declClass, String delegatorName, int index) {
        MethodInfo forwarder = new MethodInfo(cp, meth.getName(), desc);
        forwarder.setAccessFlags(0x10 | meth.getModifiers() & 0xFFFFFADF);
        ProxyFactory.setThrows(forwarder, cp, meth);
        int args = Descriptor.paramSize(desc);
        Bytecode code = new Bytecode(cp, 0, args + 2);
        int origIndex = index * 2;
        int delIndex = index * 2 + 1;
        int arrayVar = args + 1;
        code.addGetstatic(thisClassName, HOLDER, HOLDER_TYPE);
        code.addAstore(arrayVar);
        code.addAload(arrayVar);
        code.addIconst(origIndex);
        code.addOpcode(50);
        code.addOpcode(199);
        int pc = code.currentPc();
        code.addIndex(0);
        ProxyFactory.callFindMethod(code, "findSuperMethod", arrayVar, origIndex, meth.getName(), desc);
        ProxyFactory.callFindMethod(code, "findMethod", arrayVar, delIndex, delegatorName, desc);
        int pc2 = code.currentPc();
        code.write16bit(pc, pc2 - pc + 1);
        code.addAload(0);
        code.addGetfield(thisClassName, HANDLER, HANDLER_TYPE);
        code.addAload(0);
        code.addAload(arrayVar);
        code.addIconst(origIndex);
        code.addOpcode(50);
        code.addAload(arrayVar);
        code.addIconst(delIndex);
        code.addOpcode(50);
        ProxyFactory.makeParameterList(code, meth.getParameterTypes());
        code.addInvokeinterface((class$javassist$util$proxy$MethodHandler == null ? (class$javassist$util$proxy$MethodHandler = ProxyFactory.class$("javassist.util.proxy.MethodHandler")) : class$javassist$util$proxy$MethodHandler).getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        Class<?> retType = meth.getReturnType();
        ProxyFactory.addUnwrapper(code, retType);
        ProxyFactory.addReturn(code, retType);
        CodeAttribute ca = code.toCodeAttribute();
        forwarder.setCodeAttribute(ca);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.appendFrame(pc2, new int[]{7}, new int[]{cp.addClassInfo(HOLDER_TYPE)});
        ca.setAttribute(writer.toStackMapTable(cp));
        return forwarder;
    }

    private static void setThrows(MethodInfo minfo, ConstPool cp, Method orig) {
        Class[] exceptions = orig.getExceptionTypes();
        ProxyFactory.setThrows(minfo, cp, exceptions);
    }

    private static void setThrows(MethodInfo minfo, ConstPool cp, Class[] exceptions) {
        if (exceptions.length == 0) {
            return;
        }
        String[] list = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            list[i] = exceptions[i].getName();
        }
        ExceptionsAttribute ea = new ExceptionsAttribute(cp);
        ea.setExceptions(list);
        minfo.setExceptionsAttribute(ea);
    }

    private static int addLoadParameters(Bytecode code, Class[] params, int offset) {
        int stacksize = 0;
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            stacksize += ProxyFactory.addLoad(code, stacksize + offset, params[i]);
        }
        return stacksize;
    }

    private static int addLoad(Bytecode code, int n, Class type) {
        if (type.isPrimitive()) {
            if (type == Long.TYPE) {
                code.addLload(n);
                return 2;
            }
            if (type == Float.TYPE) {
                code.addFload(n);
            } else {
                if (type == Double.TYPE) {
                    code.addDload(n);
                    return 2;
                }
                code.addIload(n);
            }
        } else {
            code.addAload(n);
        }
        return 1;
    }

    private static int addReturn(Bytecode code, Class type) {
        if (type.isPrimitive()) {
            if (type == Long.TYPE) {
                code.addOpcode(173);
                return 2;
            }
            if (type == Float.TYPE) {
                code.addOpcode(174);
            } else {
                if (type == Double.TYPE) {
                    code.addOpcode(175);
                    return 2;
                }
                if (type == Void.TYPE) {
                    code.addOpcode(177);
                    return 0;
                }
                code.addOpcode(172);
            }
        } else {
            code.addOpcode(176);
        }
        return 1;
    }

    private static void makeParameterList(Bytecode code, Class[] params) {
        int regno = 1;
        int n = params.length;
        code.addIconst(n);
        code.addAnewarray("java/lang/Object");
        for (int i = 0; i < n; ++i) {
            code.addOpcode(89);
            code.addIconst(i);
            Class type = params[i];
            if (type.isPrimitive()) {
                regno = ProxyFactory.makeWrapper(code, type, regno);
            } else {
                code.addAload(regno);
                ++regno;
            }
            code.addOpcode(83);
        }
    }

    private static int makeWrapper(Bytecode code, Class type, int regno) {
        int index = FactoryHelper.typeIndex(type);
        String wrapper = FactoryHelper.wrapperTypes[index];
        code.addNew(wrapper);
        code.addOpcode(89);
        ProxyFactory.addLoad(code, regno, type);
        code.addInvokespecial(wrapper, "<init>", FactoryHelper.wrapperDesc[index]);
        return regno + FactoryHelper.dataSize[index];
    }

    private static void callFindMethod(Bytecode code, String findMethod, int arrayVar, int index, String methodName, String desc) {
        String findClass = (class$javassist$util$proxy$RuntimeSupport == null ? (class$javassist$util$proxy$RuntimeSupport = ProxyFactory.class$(NULL_INTERCEPTOR_HOLDER)) : class$javassist$util$proxy$RuntimeSupport).getName();
        String findDesc = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/reflect/Method;";
        code.addAload(arrayVar);
        code.addIconst(index);
        if (methodName == null) {
            code.addOpcode(1);
        } else {
            code.addAload(0);
            code.addLdc(methodName);
            code.addLdc(desc);
            code.addInvokestatic(findClass, findMethod, findDesc);
        }
        code.addOpcode(83);
    }

    private static void addUnwrapper(Bytecode code, Class type) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                code.addOpcode(87);
            } else {
                int index = FactoryHelper.typeIndex(type);
                String wrapper = FactoryHelper.wrapperTypes[index];
                code.addCheckcast(wrapper);
                code.addInvokevirtual(wrapper, FactoryHelper.unwarpMethods[index], FactoryHelper.unwrapDesc[index]);
            }
        } else {
            code.addCheckcast(type.getName());
        }
    }

    private static MethodInfo makeWriteReplace(ConstPool cp) {
        MethodInfo minfo = new MethodInfo(cp, "writeReplace", "()Ljava/lang/Object;");
        String[] list = new String[]{"java.io.ObjectStreamException"};
        ExceptionsAttribute ea = new ExceptionsAttribute(cp);
        ea.setExceptions(list);
        minfo.setExceptionsAttribute(ea);
        Bytecode code = new Bytecode(cp, 0, 1);
        code.addAload(0);
        code.addInvokestatic(NULL_INTERCEPTOR_HOLDER, "makeSerializedProxy", "(Ljava/lang/Object;)Ljavassist/util/proxy/SerializedProxy;");
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        return minfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ClassLoaderProvider {
        public ClassLoader get(ProxyFactory var1);
    }

    static class CacheKey {
        String classes;
        MethodFilter filter;
        private int hash;
        WeakReference proxyClass;
        MethodHandler handler;

        public CacheKey(Class superClass, Class[] interfaces, MethodFilter f, MethodHandler h) {
            this.classes = CacheKey.getKey(superClass, interfaces);
            this.hash = this.classes.hashCode();
            this.filter = f;
            this.handler = h;
            this.proxyClass = null;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey target = (CacheKey)obj;
                return target.filter == this.filter && target.handler == this.handler && target.classes.equals(this.classes);
            }
            return false;
        }

        static String getKey(Class superClass, Class[] interfaces) {
            StringBuffer sbuf = new StringBuffer();
            if (superClass != null) {
                sbuf.append(superClass.getName());
            }
            sbuf.append(':');
            if (interfaces != null) {
                int len = interfaces.length;
                for (int i = 0; i < len; ++i) {
                    sbuf.append(interfaces[i].getName()).append(',');
                }
            }
            return sbuf.toString();
        }
    }
}

