/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;

public class NtlmContext {
    NtlmPasswordAuthentication auth;
    int ntlmsspFlags;
    String workstation;
    boolean isEstablished = false;
    byte[] serverChallenge = null;
    byte[] signingKey = null;
    int state = 1;

    public NtlmContext(NtlmPasswordAuthentication auth, boolean doSigning) {
        this.auth = auth;
        this.ntlmsspFlags = this.ntlmsspFlags | 4 | 0x80000 | 0x20000000;
        if (doSigning) {
            this.ntlmsspFlags |= 0x40008010;
        }
        this.workstation = Type1Message.getDefaultWorkstation();
    }

    public boolean isEstablished() {
        return this.isEstablished;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public byte[] getSigningKey() {
        return this.signingKey;
    }

    public byte[] initSecContext(byte[] token, int offset, int len) throws SmbException {
        switch (this.state) {
            case 1: {
                Type1Message msg1 = new Type1Message(this.ntlmsspFlags, this.auth.getDomain(), this.workstation);
                token = msg1.toByteArray();
                ++this.state;
                break;
            }
            case 2: {
                try {
                    Type2Message msg2 = new Type2Message(token);
                    this.serverChallenge = msg2.getChallenge();
                    this.ntlmsspFlags &= msg2.getFlags();
                    Type3Message msg3 = new Type3Message(msg2, this.auth.getPassword(), this.auth.getDomain(), this.auth.getUsername(), this.workstation, this.ntlmsspFlags);
                    token = msg3.toByteArray();
                    if ((this.ntlmsspFlags & 0x10) != 0) {
                        this.signingKey = msg3.getMasterKey();
                    }
                    this.isEstablished = true;
                    ++this.state;
                    break;
                }
                catch (Exception e) {
                    throw new SmbException(e.getMessage());
                }
            }
            default: {
                throw new SmbException("Invalid state");
            }
        }
        return token;
    }
}

