/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TestContentLoader;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryStub;
import org.apache.jackrabbit.test.RepositoryStubException;

public class JackrabbitRepositoryStub
extends RepositoryStub {
    public static final String PROP_REPOSITORY_CONFIG = "org.apache.jackrabbit.repository.config";
    public static final String PROP_REPOSITORY_HOME = "org.apache.jackrabbit.repository.home";
    private final Properties settings;
    private static final Map<String, Repository> REPOSITORY_INSTANCES = new HashMap<String, Repository>();
    private static Principal UNKNOWN_PRINCIPAL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getStaticProperties() {
        Properties properties = new Properties();
        try {
            InputStream stream = JackrabbitRepositoryStub.getResource("JackrabbitRepositoryStub.properties");
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static InputStream getResource(String name) {
        return JackrabbitRepositoryStub.class.getResourceAsStream(name);
    }

    public JackrabbitRepositoryStub(Properties settings) {
        super(JackrabbitRepositoryStub.getStaticProperties());
        this.superuser.setAttribute("jackrabbit", "jackrabbit");
        this.readwrite.setAttribute("jackrabbit", "jackrabbit");
        this.readonly.setAttribute("jackrabbit", "jackrabbit");
        this.settings = settings;
    }

    public synchronized Repository getRepository() throws RepositoryStubException {
        try {
            String dir = this.settings.getProperty(PROP_REPOSITORY_HOME);
            dir = dir == null ? new File("target", "repository").getAbsolutePath() : new File(dir).getAbsolutePath();
            String xml = this.settings.getProperty(PROP_REPOSITORY_CONFIG);
            if (xml == null) {
                xml = new File(dir, "repository.xml").getPath();
            }
            return this.getOrCreateRepository(dir, xml);
        }
        catch (Exception e) {
            RepositoryStubException exception = new RepositoryStubException("Failed to start repository");
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository createRepository(String dir, String xml) throws Exception {
        new File(dir).mkdirs();
        if (!new File(xml).exists()) {
            InputStream input = JackrabbitRepositoryStub.getResource("repository.xml");
            try {
                FileOutputStream output = new FileOutputStream(xml);
                try {
                    IOUtils.copy(input, (OutputStream)output);
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            finally {
                input.close();
            }
        }
        RepositoryConfig config = RepositoryConfig.create(xml, dir);
        return RepositoryImpl.create(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository getOrCreateRepository(String dir, String xml) throws Exception {
        Map<String, Repository> map = REPOSITORY_INSTANCES;
        synchronized (map) {
            Repository repo = REPOSITORY_INSTANCES.get(dir);
            if (repo == null) {
                repo = this.createRepository(dir, xml);
                Session session = repo.login(this.superuser);
                try {
                    TestContentLoader loader = new TestContentLoader();
                    loader.loadTestContent(session);
                }
                finally {
                    session.logout();
                }
                REPOSITORY_INSTANCES.put(dir, repo);
            }
            return repo;
        }
    }

    public Principal getKnownPrincipal(Session session) throws RepositoryException {
        Principal knownPrincipal = null;
        if (session instanceof SessionImpl) {
            for (Principal p : ((SessionImpl)session).getSubject().getPrincipals()) {
                if (p instanceof Group) continue;
                knownPrincipal = p;
            }
        }
        if (knownPrincipal != null) {
            return knownPrincipal;
        }
        throw new RepositoryException("no applicable principal found");
    }

    public Principal getUnknownPrincipal(Session session) throws RepositoryException, NotExecutableException {
        return UNKNOWN_PRINCIPAL;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = REPOSITORY_INSTANCES;
                synchronized (map) {
                    for (Repository repo : REPOSITORY_INSTANCES.values()) {
                        if (!(repo instanceof RepositoryImpl)) continue;
                        ((RepositoryImpl)repo).shutdown();
                    }
                }
            }
        }));
        UNKNOWN_PRINCIPAL = new Principal(){

            public String getName() {
                return "an_unknown_user";
            }
        };
    }
}

