/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.iterator.EventIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.FilteredRangeIterator;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilteredEventIterator
extends EventIteratorAdapter {
    private static final Logger log = LoggerFactory.getLogger(FilteredEventIterator.class);
    private final SessionImpl session;
    private final long timestamp;
    private final String userData;

    public FilteredEventIterator(SessionImpl session, Iterator<?> eventStates, long timestamp, String userData, final EventFilter filter, final Set<?> denied) {
        super(new FilteredRangeIterator(eventStates, new Predicate(){

            public boolean evaluate(Object object) {
                try {
                    EventState state = (EventState)object;
                    return !denied.contains(state.getTargetId()) && !filter.blocks(state);
                }
                catch (RepositoryException e) {
                    log.error("Exception while applying event filter", e);
                    return false;
                }
            }
        }));
        this.session = session;
        this.timestamp = timestamp;
        this.userData = userData;
    }

    @Override
    public Object next() {
        return new EventImpl(this.session, (EventState)super.next(), this.timestamp, this.userData);
    }
}

