/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardNameQuery
extends WildcardQuery {
    private static final long serialVersionUID = -4705104992551930918L;
    private static final Logger log = LoggerFactory.getLogger(WildcardNameQuery.class);

    public WildcardNameQuery(String pattern, int transform, NamespaceResolver resolver, NamespaceMappings nsMappings) {
        super(FieldNames.LABEL, null, WildcardNameQuery.convertPattern(pattern, resolver, nsMappings), transform);
    }

    private static String convertPattern(String pattern, NamespaceResolver resolver, NamespaceMappings nsMappings) {
        String prefix = "";
        int idx = pattern.indexOf(58);
        if (idx != -1) {
            prefix = pattern.substring(0, idx);
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(nsMappings.getPrefix(resolver.getURI(prefix)));
        }
        catch (NamespaceException e) {
            log.debug("unknown namespace prefix in pattern: " + pattern);
        }
        sb.append(":");
        sb.append(pattern.substring(idx + 1));
        return sb.toString();
    }
}

