/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.util.Text;

public class CheckSchemaOperation {
    public static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    private final ConnectionHelper conHelper;
    private final InputStream ddl;
    private final String table;
    private final Map<String, String> varReplacement = new HashMap<String, String>();

    public CheckSchemaOperation(ConnectionHelper connectionhelper, InputStream ddlStream, String tableName) {
        this.conHelper = connectionhelper;
        this.ddl = ddlStream;
        this.table = tableName;
    }

    public CheckSchemaOperation addVariableReplacement(String var, String replacement) {
        this.varReplacement.put(var, replacement);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException, IOException {
        if (!this.conHelper.tableExists(this.table)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.ddl));
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = this.replace(sql);
                        this.conHelper.exec(sql, new Object[0]);
                    }
                    sql = reader.readLine();
                }
            }
            finally {
                IOUtils.closeQuietly(this.ddl);
            }
        }
    }

    private String replace(String sql) {
        String result = sql;
        for (Map.Entry<String, String> entry : this.varReplacement.entrySet()) {
            result = Text.replace(result, entry.getKey(), entry.getValue()).trim();
        }
        return result;
    }
}

