/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.search.SearchResultProperty;
import org.apache.jackrabbit.webdav.search.QueryGrammerSet;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.search.SearchResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResourceImpl
implements SearchResource {
    private static Logger log = LoggerFactory.getLogger(SearchResourceImpl.class);
    private final JcrDavSession session;
    private final DavResourceLocator locator;

    public SearchResourceImpl(DavResourceLocator locator, JcrDavSession session) {
        this.session = session;
        this.locator = locator;
    }

    @Override
    public QueryGrammerSet getQueryGrammerSet() {
        QueryGrammerSet qgs = new QueryGrammerSet();
        try {
            String[] langs;
            QueryManager qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
            for (String lang : langs = qMgr.getSupportedQueryLanguages()) {
                qgs.addQueryLanguage(lang, Namespace.EMPTY_NAMESPACE);
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return qgs;
    }

    @Override
    public MultiStatus search(SearchInfo sInfo) throws DavException {
        try {
            return this.queryResultToMultiStatus(this.getQuery(sInfo));
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getQuery(SearchInfo sInfo) throws InvalidQueryException, RepositoryException, DavException {
        Query q;
        String itemPath;
        block16: {
            block15: {
                Node qNode;
                String qNodeRelPath;
                Session session = this.getRepositorySession();
                NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
                Node rootNode = session.getRootNode();
                QueryManager qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
                itemPath = this.locator.getRepositoryPath();
                if (itemPath != null && !rootNode.getPath().equals(itemPath) && rootNode.hasNode(qNodeRelPath = itemPath.substring(1)) && (qNode = rootNode.getNode(qNodeRelPath)).isNodeType("nt:query")) {
                    return qMgr.getQuery(qNode);
                }
                if (sInfo == null) break block15;
                Map<String, String> namespaces = sInfo.getNamespaces();
                try {
                    for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                        String prefix = entry.getKey();
                        String uri = entry.getValue();
                        session.setNamespacePrefix(prefix, uri);
                    }
                    q = qMgr.createQuery(sInfo.getQuery(), sInfo.getLanguageName());
                    if (-1L != sInfo.getNumberResults()) {
                        q.setLimit(sInfo.getNumberResults());
                    }
                    if (-1L != sInfo.getOffset()) {
                        q.setOffset(sInfo.getOffset());
                    }
                }
                catch (Throwable throwable) {
                    for (String uri : namespaces.values()) {
                        try {
                            session.setNamespacePrefix(nsReg.getPrefix(uri), uri);
                        }
                        catch (RepositoryException e) {
                            log.warn("Unable to reset mapping of namespace: " + uri);
                        }
                    }
                    throw throwable;
                }
                for (String uri : namespaces.values()) {
                    try {
                        session.setNamespacePrefix(nsReg.getPrefix(uri), uri);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to reset mapping of namespace: " + uri);
                    }
                }
                break block16;
            }
            throw new DavException(400, this.locator.getResourcePath() + " is not a nt:query node -> searchRequest body required.");
        }
        if (itemPath != null && !this.getRepositorySession().itemExists(itemPath)) {
            try {
                q.storeAsNode(itemPath);
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        }
        return q;
    }

    private MultiStatus queryResultToMultiStatus(Query query) throws RepositoryException {
        QueryResult qResult = query.execute();
        MultiStatus ms = new MultiStatus();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.addAll(Arrays.asList(qResult.getColumnNames()));
        StringBuffer responseDescription = new StringBuffer();
        String delim = "";
        for (String columnName : columnNames) {
            responseDescription.append(delim);
            responseDescription.append(ISO9075.encode(columnName));
            delim = " ";
        }
        ms.setResponseDescription(responseDescription.toString());
        ValueFactory vf = this.getRepositorySession().getValueFactory();
        ArrayList<RowValue> descr = new ArrayList<RowValue>();
        Iterator it = columnNames.iterator();
        while (it.hasNext()) {
            String columnName = (String)it.next();
            if (!SearchResourceImpl.isPathOrScore(columnName)) {
                descr.add(new PlainValue(columnName, null, vf));
                continue;
            }
            it.remove();
        }
        ArrayList<String> sn = new ArrayList<String>();
        SearchResourceImpl.collectSelectorNames(query, qResult, sn);
        for (String selectorName : sn) {
            descr.add(new PathValue("jcr:path", selectorName, vf));
            columnNames.add("jcr:path");
            descr.add(new ScoreValue("jcr:score", selectorName, vf));
            columnNames.add("jcr:score");
        }
        String[] selectorNames = SearchResourceImpl.createSelectorNames(descr);
        String[] colNames = columnNames.toArray(new String[columnNames.size()]);
        RowIterator rowIter = qResult.getRows();
        while (rowIter.hasNext()) {
            Row row = rowIter.nextRow();
            ArrayList<Value> values = new ArrayList<Value>();
            for (RowValue rv : descr) {
                values.add(rv.getValue(row));
            }
            String itemPath = row.getPath();
            DavResourceLocator loc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), itemPath, false);
            String href = loc.getHref(true);
            MultiStatusResponse resp = new MultiStatusResponse(href, null);
            SearchResultProperty srp = new SearchResultProperty(colNames, selectorNames, values.toArray(new Value[values.size()]));
            resp.add(srp);
            ms.addResponse(resp);
        }
        return ms;
    }

    private static String[] createSelectorNames(Iterable<RowValue> rows) throws RepositoryException {
        ArrayList<String> sn = new ArrayList<String>();
        for (RowValue rv : rows) {
            sn.add(rv.getSelectorName());
        }
        return sn.toArray(new String[sn.size()]);
    }

    private static boolean isPathOrScore(String columnName) {
        return "jcr:path".equals(columnName) || "jcr:score".equals(columnName);
    }

    private Session getRepositorySession() {
        return this.session.getRepositorySession();
    }

    private static void collectSelectorNames(Query query, QueryResult result, List<String> sn) throws RepositoryException {
        if (query instanceof QueryObjectModel) {
            QueryObjectModel qom = (QueryObjectModel)query;
            SearchResourceImpl.collectSelectorNames(qom.getSource(), sn);
        } else {
            sn.addAll(Arrays.asList(result.getSelectorNames()));
        }
    }

    private static void collectSelectorNames(Source source, List<String> sn) {
        if (source instanceof Join) {
            SearchResourceImpl.collectSelectorNames((Join)source, sn);
        } else {
            SearchResourceImpl.collectSelectorNames((Selector)source, sn);
        }
    }

    private static void collectSelectorNames(Join join, List<String> sn) {
        SearchResourceImpl.collectSelectorNames(join.getLeft(), sn);
        SearchResourceImpl.collectSelectorNames(join.getRight(), sn);
    }

    private static void collectSelectorNames(Selector s, List<String> sn) {
        sn.add(s.getSelectorName());
    }

    private static final class PathValue
    extends SelectorValue {
        public PathValue(String columnName, String selectorName, ValueFactory vf) {
            super(columnName, selectorName, vf);
        }

        public Value getValue(Row row) throws RepositoryException {
            String path = this.selectorName != null ? row.getPath(this.selectorName) : row.getPath();
            return path == null ? null : this.vf.createValue(path, 8);
        }
    }

    private static final class ScoreValue
    extends SelectorValue {
        public ScoreValue(String columnName, String selectorName, ValueFactory vf) {
            super(columnName, selectorName, vf);
        }

        public Value getValue(Row row) throws RepositoryException {
            double score = this.selectorName != null ? row.getScore(this.selectorName) : row.getScore();
            return this.vf.createValue(score);
        }
    }

    private static abstract class SelectorValue
    implements RowValue {
        protected final String columnName;
        protected final String selectorName;
        protected final ValueFactory vf;

        public SelectorValue(String columnName, String selectorName, ValueFactory vf) {
            this.columnName = columnName;
            this.selectorName = selectorName;
            this.vf = vf;
        }

        public String getColumnName() throws RepositoryException {
            return this.columnName;
        }

        public String getSelectorName() throws RepositoryException {
            return this.selectorName;
        }
    }

    private static final class PlainValue
    extends SelectorValue {
        public PlainValue(String columnName, String selectorName, ValueFactory vf) {
            super(columnName, selectorName, vf);
        }

        public Value getValue(Row row) throws RepositoryException {
            return row.getValue(this.columnName);
        }
    }

    private static interface RowValue {
        public Value getValue(Row var1) throws RepositoryException;

        public String getColumnName() throws RepositoryException;

        public String getSelectorName() throws RepositoryException;
    }
}

