/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.extractor;

import java.io.IOException;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.DrawingParagraph;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFCommonSlideData;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;

public class XSLFPowerPointExtractor
extends POIXMLTextExtractor {
    public static final XSLFRelation[] SUPPORTED_TYPES = new XSLFRelation[]{XSLFRelation.MAIN, XSLFRelation.MACRO, XSLFRelation.MACRO_TEMPLATE, XSLFRelation.PRESENTATIONML, XSLFRelation.PRESENTATIONML_TEMPLATE, XSLFRelation.PRESENTATION_MACRO};
    private XMLSlideShow slideshow;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;

    public XSLFPowerPointExtractor(XMLSlideShow slideshow) {
        super(slideshow._getXSLFSlideShow());
        this.slideshow = slideshow;
    }

    public XSLFPowerPointExtractor(XSLFSlideShow slideshow) throws XmlException, IOException {
        this(new XMLSlideShow(slideshow));
    }

    public XSLFPowerPointExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XSLFSlideShow(container));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  HXFPowerPointExtractor <filename.pptx>");
            System.exit(1);
        }
        XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(new XSLFSlideShow(args[0]));
        System.out.println(((POITextExtractor)extractor).getText());
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
    }

    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault);
    }

    public String getText(boolean slideText, boolean notesText) {
        StringBuffer text = new StringBuffer();
        XSLFSlide[] slides = this.slideshow.getSlides();
        for (int i = 0; i < slides.length; ++i) {
            CTSlide rawSlide = slides[i]._getCTSlide();
            CTSlideIdListEntry slideId = slides[i]._getCTSlideId();
            try {
                CTNotesSlide notes = this.slideshow._getXSLFSlideShow().getNotes(slideId);
                CTCommentList comments = this.slideshow._getXSLFSlideShow().getSlideComments(slideId);
                if (slideText) {
                    this.extractText(slides[i].getCommonSlideData(), text);
                    if (comments != null) {
                        for (CTComment comment : comments.getCmList()) {
                            text.append(comment.getText() + "\n");
                        }
                    }
                }
                if (!notesText || notes == null) continue;
                this.extractText(new XSLFCommonSlideData(notes.getCSld()), text);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return text.toString();
    }

    private void extractText(XSLFCommonSlideData data, StringBuffer text) {
        for (DrawingParagraph p : data.getText()) {
            text.append(p.getText());
            text.append("\n");
        }
    }
}

