/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.POIXMLTextExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XWPFWordExtractorDecorator;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OOXMLExtractorFactory {
    public static void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Locale locale = context.get(Locale.class, Locale.getDefault());
        try {
            POIXMLTextExtractor poiExtractor = stream instanceof TikaInputStream && ((TikaInputStream)stream).getOpenContainer() != null ? ExtractorFactory.createExtractor((OPCPackage)((TikaInputStream)stream).getOpenContainer()) : (POIXMLTextExtractor)ExtractorFactory.createExtractor(stream);
            POIXMLDocument document = poiExtractor.getDocument();
            AbstractOOXMLExtractor extractor = document instanceof XSLFSlideShow ? new XSLFPowerPointExtractorDecorator((XSLFPowerPointExtractor)poiExtractor) : (document instanceof XSSFWorkbook ? new XSSFExcelExtractorDecorator((XSSFExcelExtractor)poiExtractor, locale) : (document instanceof XWPFDocument ? new XWPFWordExtractorDecorator((XWPFWordExtractor)poiExtractor) : new POIXMLTextExtractorDecorator(poiExtractor)));
            extractor.getMetadataExtractor().extract(metadata);
            extractor.getXHTML(handler, metadata, context);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("No supported documents found")) {
                throw new TikaException("TIKA-418: RuntimeException while getting content for thmx and xps file types", e);
            }
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (OpenXML4JException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
        catch (XmlException e) {
            throw new TikaException("Error creating OOXML extractor", e);
        }
    }
}

