/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.resteasy.annotations.providers.jaxb.JAXBConfig;
import org.jboss.resteasy.core.LoggerCategories;
import org.jboss.resteasy.plugins.providers.jaxb.XmlNamespacePrefixMapper;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextWrapper
extends JAXBContext {
    private static final Logger logger = LoggerCategories.getProviderLogger();
    private static final String NAMESPACE_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private JAXBContext wrappedContext;
    private XmlNamespacePrefixMapper mapper;
    private Schema schema;

    public JAXBContextWrapper(JAXBContext wrappedContext, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        this.wrappedContext = wrappedContext;
    }

    public JAXBContextWrapper(Class<?>[] classes, Map<String, Object> properties, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        this.wrappedContext = JAXBContext.newInstance((Class[])classes, properties);
    }

    public JAXBContextWrapper(String contextPath, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        this.wrappedContext = JAXBContext.newInstance(contextPath);
    }

    public JAXBContextWrapper(JAXBConfig config, Class<?> ... classes) throws JAXBException {
        this(classes, Collections.emptyMap(), config);
    }

    private void processConfig(JAXBConfig config) throws JAXBException {
        if (config != null) {
            if (config.useNameSpacePrefix()) {
                this.mapper = new XmlNamespacePrefixMapper(config.namespaces());
            }
            if (!"".equals(config.schema())) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance(config.schemaType());
                try {
                    InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(config.schema());
                    this.schema = schemaFactory.newSchema(new StreamSource(in));
                }
                catch (SAXException e) {
                    throw new JAXBException("Error wil trying to load schema for " + config.schema(), e);
                }
            }
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Binder<Node> createBinder() {
        return this.wrappedContext.createBinder();
    }

    @Override
    public <T> Binder<T> createBinder(Class<T> domType) {
        return this.wrappedContext.createBinder(domType);
    }

    @Override
    public JAXBIntrospector createJAXBIntrospector() {
        return this.wrappedContext.createJAXBIntrospector();
    }

    @Override
    public Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.wrappedContext.createMarshaller();
        if (this.mapper != null) {
            try {
                marshaller.setProperty(NAMESPACE_PREFIX_MAPPER, this.mapper);
            }
            catch (PropertyException e) {
                logger.warn(e.getMessage());
            }
        }
        return marshaller;
    }

    @Override
    public Unmarshaller createUnmarshaller() throws JAXBException {
        return this.wrappedContext.createUnmarshaller();
    }

    @Override
    public Validator createValidator() throws JAXBException {
        return this.wrappedContext.createValidator();
    }

    @Override
    public void generateSchema(SchemaOutputResolver outputResolver) throws IOException {
        this.wrappedContext.generateSchema(outputResolver);
    }
}

