/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class JAXBElementProvider
extends AbstractJAXBProvider<JAXBElement<?>> {
    @Override
    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElement.class.equals(type);
    }

    @Override
    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        JAXBElement<Object> result;
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument(genericType);
        }
        JAXBContext jaxb = null;
        try {
            jaxb = this.findJAXBContext(typeArg, annotations, mediaType, true);
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
        try {
            JAXBElement<Object> e;
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            result = e = unmarshaller.unmarshal(new StreamSource(entityStream), typeArg);
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
        JAXBElement<Object> element = result;
        return element;
    }

    @Override
    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        Class typeArg = Object.class;
        if (genericType != null) {
            typeArg = Types.getTypeArgument(genericType);
        }
        super.writeTo(t, typeArg, genericType, annotations, mediaType, httpHeaders, outputStream);
    }
}

