/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.FieldEnablerPrivilegedAction;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInputImpl;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.util.FindAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"multipart/form-data"})
public class MultipartFormAnnotationReader
implements MessageBodyReader<Object> {
    @Context
    protected Providers workers;

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return FindAnnotation.findAnnotation(annotations, MultipartForm.class) != null || type.isAnnotationPresent(MultipartForm.class);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object obj;
        String boundary = mediaType.getParameters().get("boundary");
        if (boundary == null) {
            throw new IOException("Unable to get boundary for multipart");
        }
        MultipartFormDataInputImpl input = new MultipartFormDataInputImpl(mediaType, this.workers);
        input.parse(entityStream);
        try {
            obj = type.newInstance();
        }
        catch (InstantiationException e) {
            throw new ReaderException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new ReaderException(e);
        }
        for (Class<Object> theType = type; theType != null && !theType.equals(Object.class); theType = theType.getSuperclass()) {
            this.setFields(theType, input, obj);
        }
        for (Method method : type.getMethods()) {
            InputPart part;
            if (!method.isAnnotationPresent(FormParam.class) || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            FormParam param = method.getAnnotation(FormParam.class);
            List<InputPart> list = input.getFormDataMap().get(param.value());
            if (list == null || list.isEmpty() || (part = list.get(0)) == null) continue;
            Object data = part.getBody(method.getParameterTypes()[0], method.getGenericParameterTypes()[0]);
            try {
                method.invoke(obj, data);
            }
            catch (IllegalAccessException e) {
                throw new ReaderException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReaderException(e.getCause());
            }
        }
        return obj;
    }

    protected void setFields(Class<?> type, MultipartFormDataInputImpl input, Object obj) throws IOException {
        for (Field field : type.getDeclaredFields()) {
            InputPart part;
            if (!field.isAnnotationPresent(FormParam.class)) continue;
            AccessController.doPrivileged(new FieldEnablerPrivilegedAction(field));
            FormParam param = field.getAnnotation(FormParam.class);
            List<InputPart> list = input.getFormDataMap().get(param.value());
            if (list == null || list.isEmpty() || (part = list.get(0)) == null) continue;
            Object data = part.getBody(field.getType(), field.getGenericType());
            try {
                field.set(obj, data);
            }
            catch (IllegalAccessException e) {
                throw new ReaderException(e);
            }
        }
    }
}

