/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.i18n;

import java.util.Locale;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.core.NamedThreadLocal;

public abstract class LocaleContextHolder {
    private static final ThreadLocal<LocaleContext> localeContextHolder = new NamedThreadLocal<LocaleContext>("Locale context");
    private static final ThreadLocal<LocaleContext> inheritableLocaleContextHolder = new NamedInheritableThreadLocal<LocaleContext>("Locale context");

    public static void resetLocaleContext() {
        localeContextHolder.set(null);
        inheritableLocaleContextHolder.set(null);
    }

    public static void setLocaleContext(LocaleContext localeContext) {
        LocaleContextHolder.setLocaleContext(localeContext, false);
    }

    public static void setLocaleContext(LocaleContext localeContext, boolean inheritable) {
        if (inheritable) {
            inheritableLocaleContextHolder.set(localeContext);
            localeContextHolder.set(null);
        } else {
            localeContextHolder.set(localeContext);
            inheritableLocaleContextHolder.set(null);
        }
    }

    public static LocaleContext getLocaleContext() {
        LocaleContext localeContext = localeContextHolder.get();
        if (localeContext == null) {
            localeContext = inheritableLocaleContextHolder.get();
        }
        return localeContext;
    }

    public static void setLocale(Locale locale) {
        LocaleContextHolder.setLocale(locale, false);
    }

    public static void setLocale(Locale locale, boolean inheritable) {
        SimpleLocaleContext localeContext = locale != null ? new SimpleLocaleContext(locale) : null;
        LocaleContextHolder.setLocaleContext(localeContext, inheritable);
    }

    public static Locale getLocale() {
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        return localeContext != null ? localeContext.getLocale() : Locale.getDefault();
    }
}

